/*
 * Function.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.data.fit;

import adams.core.ClassLister;

/**
 * Abstract superclass for arbitrary (linear) functions that calculate 
 * coefficients and y values based on the given x values.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2537 $
 */
public abstract class LinearFunction
  extends Function {
  
  /** for serialization. */
  private static final long serialVersionUID = 4732946747339219463L;

  /**
   * Calculates the function values, based on the x value.
   * 
   * @param x		the x value
   * @param num		the number of basis functions
   * @return		the function values, gets updated
   */
  public abstract double[] calcFunctionValues(double x, int num);
  
  /**
   * Returns a list with classnames of linear functions.
   * 
   * @return		the linear function classnames
   */
  public static String[] getLinearFunctions() {
    return ClassLister.getSingleton().getClassnames(LinearFunction.class);
  }
}
