/*
 * Function.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.data.fit;

import adams.core.ClassLister;

/**
 * Abstract superclass for arbitrary (non-linear) functions that calculate 
 * partial derivative values and y values based on the given x values.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2537 $
 */
public abstract class NonlinearFunction
  extends Function {
  
  /** for serialization. */
  private static final long serialVersionUID = -309038443545186994L;

  /**
   * Calculates the partial derivatives based on the x value and the 
   * coefficients.
   * 
   * @param x		the x value
   * @param a		the coefficents
   * @return		the partial derivatives
   */
  public abstract double[] calcDerivatives(double x, double[] a);
  
  /**
   * Returns a list with classnames of non-linear functions.
   * 
   * @return		the non-linear function classnames
   */
  public static String[] getNonlinearFunctions() {
    return ClassLister.getSingleton().getClassnames(NonlinearFunction.class);
  }
}
