/*
 * PassThrough.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.data.report;

import adams.data.container.DataContainer;

/**
 <!-- globalinfo-start -->
 * A dummy filter that just passes the data through. No modifications to the report whatsoever.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1259 $
 */
public class PassThrough
  extends AbstractReportFilter {

  /** for serialization. */
  private static final long serialVersionUID = 8646651693938769168L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return
        "A dummy filter that just passes the data through. No modifications to "
      + "the report whatsoever.";
  }

  /**
   * Does nothing with the report.
   *
   * @param data	the data to filter
   * @return		the filtered data
   */
  protected DataContainer processData(DataContainer data) {
    return data;
  }
}
