/**
 * AdditionalOptionsHandler.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

/**
 * Interface for scripting actors that need to set additional options.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1164 $
 */
public interface AdditionalOptionsHandler {

  /**
   * Sets the additional options.
   *
   * @param options	the options (name &lt;-&gt;value relation)
   */
  public void setAdditionalOptions(AdditionalOptions options);

  /**
   * Returns the additional options.
   *
   * @return	the options (name &lt;-&gt;value relation)
   */
  public AdditionalOptions getAdditionalOptions();
}
