/*
 * NullToken.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.core;

/**
 * A dummy token without any payload.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public class NullToken
  extends Token {

  /** for serialization. */
  private static final long serialVersionUID = -2164551823465416849L;
  
  /**
   * Ignores any payload.
   * 
   * @param value	ignored
   */
  public void setPayload(Object value) {
  }
  
  /**
   * Returns a string representation of the payload.
   * 
   * @return		the string representation
   */
  public String toString() {
    return "Token #" + hashCode();
  }
}
