/**
 * ComponentSupplier.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink;

import javax.swing.JComponent;

/**
 * Interface for sinks that supply a component. This can be used for saving
 * this component.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1010 $
 */
public interface ComponentSupplier {

  /**
   * Supplies the component.
   *
   * @return		the component, null if none available
   */
  public JComponent supplyComponent();
}
