/*
 * FieldChooserPanel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.chooser;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.FieldType;
import adams.data.report.FieldUtils;
import adams.gui.selection.SelectFieldDialog;

/**
 * A panel that contains a text field with the current field and a
 * button for bringing up a dialog for selecting from all available fields.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3561 $
 */
public class FieldChooserPanel
  extends AbstractChooserPanel<AbstractField> {

  /** for serialization. */
  private static final long serialVersionUID = -7800388925398386462L;

  /** the dialog for selecting a field. */
  protected SelectFieldDialog m_Dialog;

  /**
   * Initializes the panel with no field.
   */
  public FieldChooserPanel() {
    this(null);
  }

  /**
   * Initializes the panel with the given field.
   *
   * @param field	the field to use, can be null
   */
  public FieldChooserPanel(AbstractField field) {
    super();

    if (field != null)
      setCurrent(field);
  }

  /**
   * Initializes the members.
   */
  protected void initialize() {
    super.initialize();

    if (getParentDialog() != null)
      m_Dialog = new SelectFieldDialog(getParentDialog());
    else
      m_Dialog = new SelectFieldDialog(getParentFrame());
  }

  /**
   * Performs the actual choosing of an object.
   *
   * @return		the chosen object or null if none chosen
   */
  protected AbstractField doChoose() {
    if (hasValue())
      m_Dialog.setItem(getCurrent());
    m_Dialog.setLocationRelativeTo(this);
    m_Dialog.setVisible(true);
    if (m_Dialog.getOption() == SelectFieldDialog.APPROVE_OPTION)
      return m_Dialog.getItem();
    else
      return null;
  }

  /**
   * Converts the value into its string representation.
   *
   * @param value	the value to convert
   * @return		the generated string
   */
  protected String toString(AbstractField value) {
    return value.toString();
  }

  /**
   * Converts the string representation into its object representation.
   *
   * @param value	the string value to convert
   * @return		the generated object
   */
  protected AbstractField fromString(String value) {
    return (Field) FieldUtils.fixClass(getFieldType(), new Field(value, DataType.UNKNOWN));
  }

  /**
   * Sets the field type.
   *
   * @param value	the new field type
   */
  public void setFieldType(FieldType value) {
    setCurrent(null);
    m_Dialog.setFieldType(value);
  }

  /**
   * Returns the field type.
   *
   * @return		the current field type
   */
  public FieldType getFieldType() {
    return m_Dialog.getFieldType();
  }
}
