/**
 * ComparableTableModel.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.core;

import javax.swing.table.TableModel;

/**
 * Interface for TableModel classes that need to use different values for
 * sorting. E.g., when the underlying object is different from the one being
 * displayed. This interface is used in the <code>SortedTableModel</code> class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3492 $
 * @see SortableAndSearchableWrapperTableModel
 */
public interface ComparableTableModel
  extends TableModel {

  /**
   * Returns the class type of the column that is used for comparisons.
   *
   * @param columnIndex	the column to get the class for
   * @return		the class for the column
   */
  public Class getComparisonColumnClass(int columnIndex);

  /**
   * Returns the field at the given position.
   *
   * @param row		the row
   * @param column	the column (ignored, since only 1 column)
   * @return		the field
   */
  public Object getComparisonValueAt(int row, int column);
}
