/*
 * PropertiesTableModel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.core;

import java.util.Collections;
import java.util.Vector;

import adams.core.Properties;

/**
 * Table model for displaying a properties object.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3573 $
 */
public class PropertiesTableModel
  extends KeyValuePairTableModel {

  /** for serialization. */
  private static final long serialVersionUID = -7651644993347866043L;

  /**
   * Initializes the table model with no data.
   */
  public PropertiesTableModel() {
    super(new String[0][]);
  }

  /**
   * Initializes the table model.
   *
   * @param props	the props to display
   */
  public PropertiesTableModel(Properties props) {
    super(convert(props));
  }

  /**
   * Returns the current content as properties.
   *
   * @return		the properties
   */
  public Properties getProperties() {
    Properties	result;
    int		i;

    result = new Properties();

    for (i = 0; i < m_Data.length; i++)
      result.setProperty(m_Data[i][0].toString(), m_Data[i][1].toString());

    return result;
  }

  /**
   * Turns the properties into key-value pairs. The keys are sorted
   * alphabetically.
   *
   * @param data	the data to convert
   * @return		the converted data
   */
  protected static String[][] convert(Properties data) {
    String[][]		result;
    Vector<String> 	keys;

    keys = new Vector<String>(data.keySetAll());
    Collections.sort(keys);
    result = new String[keys.size()][2];
    for (int i = 0; i < keys.size(); i++) {
      result[i][0] = keys.get(i);
      result[i][1] = data.getProperty(keys.get(i));
    }

    return result;
  }
}