/*
 * UndoHandler.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.core;


/**
 * Interface for classes that support an optional undo-mechanism.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public interface UndoHandler {
  
  /**
   * Sets the undo manager to use, can be null if no undo-support wanted.
   * 
   * @param value	the undo manager to use
   */
  public void setUndo(Undo value);
  
  /**
   * Returns the current undo manager, can be null.
   * 
   * @return		the undo manager, if any
   */
  public Undo getUndo();

  /**
   * Returns whether an Undo manager is currently available.
   * 
   * @return		true if an undo manager is set
   */
  public boolean isUndoSupported();
}
