/*
 * PaintEvent.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.event;

import java.awt.Graphics;
import java.util.EventObject;

/**
 * Event that gets sent in case of a paint update of a GUI component.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3929 $
 */
public class PaintEvent
  extends EventObject {

  /**
   * Enumeration indicating what paintlets should be executed.
   *
   * @author  fracpete (fracpete at waikato dot ac dot nz)
   * @version $Revision: 3929 $
   */
  public enum PaintMoment {
    /** execute the paintlet just after the background got cleared, before the grid is drawn. */
    BACKGROUND,
    /** execute the paintlet just after the grid was drawn, before any other painting happens. */
    GRID,
    /** execute the paintlet <i>before</i> the panel's main painting. */
    PRE_PAINT,
    /** execute the paintlet <i>as</i> the panel's main painting. */
    PAINT,
    /** execute the paintlet <i>after</i> the panel's main painting. */
    POST_PAINT
  }

  /** for serialization. */
  private static final long serialVersionUID = 7509294691540485379L;

  /** the graphics context. */
  protected Graphics m_Graphics;

  /** the paint momment. */
  protected PaintMoment m_PaintMoment;

  /**
   * Initializes the event.
   *
   * @param source	the source of the event
   * @param g		the graphics context
   * @param moment	the paint momentm only paintlets of this moment should
   * 			draw themselves
   */
  public PaintEvent(Object source, Graphics g, PaintMoment moment) {
    super(source);

    m_Graphics    = g;
    m_PaintMoment = moment;
  }

  /**
   * Returns the corresponding graphics context.
   *
   * @return		the graphics context
   */
  public Graphics getGraphics() {
    return m_Graphics;
  }

  /**
   * Returns the paint moment of which a paintlet has to be in order to be
   * executed.
   *
   * @return		the paint moment
   */
  public PaintMoment getPaintMoment() {
    return m_PaintMoment;
  }
}
