/*
 * RecentFileEvent.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.event;


import java.io.File;
import java.util.EventObject;

import adams.gui.core.RecentFilesHandler;

/**
 * Event that gets sent when recent files change or get selected.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public class RecentFileEvent
  extends EventObject {

  /** for serialization. */
  private static final long serialVersionUID = 4812680587917660625L;

  /** the affected file. */
  protected File m_File;
  
  /**
   * Initializes the event.
   * 
   * @param source	the handler that triggered the event
   * @param file	the affected file
   */
  public RecentFileEvent(RecentFilesHandler source, File file) {
    super(source);
    
    m_File = file;
  }
  
  /**
   * Returns the handler that triggered the event.
   * 
   * @return		the handler
   */
  public RecentFilesHandler getHandler() {
    return (RecentFilesHandler) getSource();
  }
  
  /**
   * Returns the affected file.
   * 
   * @return		the file
   */
  public File getFile() {
    return m_File;
  }
}
