/**
 * BooleanEditor.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.goe;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;
import javax.swing.JComponent;

/**
 * A custom editor for Booleans.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1733 $
 */
public class BooleanEditor
  extends AbstractBasicTypePropertyEditor {

  /** the current value. */
  protected Boolean m_Current;

  /**
   * Initializes the editor.
   */
  public BooleanEditor() {
    super();

    m_Current = false;
  }

  /**
   * Creates the custom editor to use.
   *
   * @return		the custom editor
   */
  protected JComponent createCustomEditor() {
    JCheckBox	result;

    result = new JCheckBox();
    result.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	JCheckBox checkbox = (JCheckBox) e.getSource();
	if (!getValue().equals(checkbox.isSelected()))
	  setValue(checkbox.isSelected());
      }
    });

    return result;
  }

  /**
   * Set (or change) the object that is to be edited.  Primitive types such
   * as "int" must be wrapped as the corresponding object type such as
   * "java.lang.Boolean".
   *
   * @param value The new target object to be edited.  Note that this
   *     object should not be modified by the PropertyEditor, rather
   *     the PropertyEditor should create a new object to hold any
   *     modified value.
   */
  public void setValue(Object value) {
    m_Current = new Boolean((Boolean) value);
    firePropertyChange();
  }

  /**
   * Gets the property value.
   *
   * @return The value of the property.  Primitive types such as "int" will
   * be wrapped as the corresponding object type such as "java.lang.Boolean".
   */

  public Object getValue() {
    return m_Current;
  }

  /**
   * Parses the string and returns an object of the correct class.
   *
   * @param text	the string to parse
   * @return		the generated object
   * @throws IllegalArgumentException	if parsing fails
   */
  protected Object parse(String text) throws IllegalArgumentException {
    Object	result;

    try {
      if (text.length() == 0)
	text = "" + false;
      result = new Boolean(text);
    }
    catch (Exception e) {
      throw new IllegalArgumentException(e);
    }

    return result;
  }

  /**
   * Initializes the display of the value.
   */
  protected void initForDisplay() {
    if (!m_Current.equals(((JCheckBox) m_CustomEditor).isSelected()))
      ((JCheckBox) m_CustomEditor).setSelected(m_Current);
  }
}
