/*
 * CustomStringRepresentationHandler.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe;

/**
 * For property editors that support a custom string representation of
 * their objects.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 69 $
 */
public interface CustomStringRepresentationHandler {

  /**
   * Returns a custom string representation of the object.
   * 
   * @param obj		the object to turn into a string
   * @return		the string representation
   */
  public String toCustomStringRepresentation(Object obj);

  /**
   * Returns an object created from the custom string representation.
   * 
   * @param str		the string to turn into an object
   * @return		the object
   */
  public Object fromCustomStringRepresentation(String str);
}
