/*
 * GlobalActorsNode.java
 * Copyright (C) 2011-2012 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.globalactorstree;

import adams.flow.standalone.GlobalActors;
import adams.gui.goe.actorpathtree.ActorPathNode;

/**
 * Specialized tree node.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4259 $
 */
public class GlobalActorsNode
  extends ActorPathNode {

  /** for serialization. */
  private static final long serialVersionUID = 9062259637831548370L;

  /**
   * Initializes the class node with the specified label (package or class
   * name).
   *
   * @param label	the label for this node
   */
  public GlobalActorsNode(String label) {
    super(label);
  }

  /**
   * Returns whether this node represents a global actor.
   *
   * @return		true if a global actor
   */
  public boolean isGlobalActor() {
    return ((m_Classname != null) && !m_Classname.equals(GlobalActors.class.getName()));
  }
}