/*
 * GlobalActorsTree.java
 * Copyright (C) 2011-2012 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.globalactorstree;

import java.util.Enumeration;

import javax.swing.tree.TreePath;

import adams.gui.core.BaseTreeNode;
import adams.gui.goe.actorpathtree.ActorPathTree;

/**
 * Displays classes in a tree structure.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4259 $
 */
public class GlobalActorsTree
  extends ActorPathTree<GlobalActorsNode> {

  /** for serialization. */
  private static final long serialVersionUID = 1489354474021395304L;

  /**
   * Initializes the tree with no classes.
   */
  public GlobalActorsTree() {
    super();
  }

  /**
   * Returns a new instance of a node.
   *
   * @param label	the label to use
   * @return		the new node
   * @see		#newNode(String)
   */
  protected GlobalActorsNode newNodeInstance(String label) {
    return new GlobalActorsNode(label);
  }

  /**
   * Selects the global actor identified by the name.
   *
   * @param name	the name of the global actor
   */
  public GlobalActorsNode findGlobalActor(String name) {
    GlobalActorsNode	result;
    BaseTreeNode	node;
    Enumeration		enm;
    GlobalActorsNode	child;

    result = null;

    if ((name != null) && (name.length() > 0)) {
      node = (BaseTreeNode) getTreeModel().getRoot();
      if (node != null) {
	enm = node.breadthFirstEnumeration();
	while (enm.hasMoreElements()) {
	  node = (BaseTreeNode) enm.nextElement();
	  if (node instanceof GlobalActorsNode) {
	    child = (GlobalActorsNode) node;
	    if (child.isGlobalActor() && child.getLabel().equals(name)) {
	      result = child;
	      break;
	    }
	  }
	}
      }
    }

    return result;
  }

  /**
   * Selects the global actor identified by the name.
   *
   * @param name	the name of the global actor
   */
  public void selectGlobalActor(String name) {
    GlobalActorsNode	node;
    TreePath		path;

    node = findGlobalActor(name);
    if (node != null) {
      path = new TreePath(node.getPath());
      setSelectionPath(path);
    }
  }
}
