/**
 * AbstractDataContainerPanelScriptlet.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import adams.gui.visualization.container.DataContainerPanel;


/**
 * Ancestor for scriptlets that require a DataContainerPanel.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 501 $
 */
public abstract class AbstractDataContainerPanelScriptlet
  extends AbstractUndoScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = 1693024372320455031L;

  /**
   * Returns the class(es) of an object that must be present for this action
   * to be executed.
   *
   * @return		the class(es) of which an instance must be present for
   * 			execution, null if none necessary
   */
  public Class[] getRequirements() {
    return new Class[]{DataContainerPanel.class};
  }

  /**
   * Returns the spectrum panel, if available.
   *
   * @return		the panel
   */
  public DataContainerPanel getDataContainerPanel() {
    if (hasOwner())
      return ((CommandProcessor) getOwner()).getDataContainerPanel();
    else
      return null;
  }
}
