/**
 * ScriptingDialog.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import java.awt.Dialog;
import java.awt.Frame;

import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.core.BasePanel;

/**
 * A dialog for loading/saving and executing scripts.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class ScriptingDialog
  extends AbstractScriptingDialog {

  /** for serialization. */
  private static final long serialVersionUID = 8200417116225554201L;

  /**
   * Creates a non-modal dialog.
   *
   * @param owner	the owning dialog
   * @param panel	the base panel this dialog belongs to
   */
  public ScriptingDialog(Dialog owner, BasePanel panel) {
    super(owner, panel);
  }

  /**
   * Creates a non-modal dialog.
   *
   * @param owner	the owning frame
   * @param panel	the base panel this dialog belongs to
   */
  public ScriptingDialog(Frame owner, BasePanel panel) {
    super(owner, panel);
  }

  /**
   * Returns the default database connection.
   *
   * @return		the database connection
   */
  protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
    return DatabaseConnection.getSingleton();
  }

  /**
   * Returns the current scripting engine, can be null.
   *
   * @return		the current engine
   */
  public AbstractScriptingEngine getScriptingEngine() {
    return ScriptingEngine.getSingleton(getDatabaseConnection());
  }
}
