/**
 * Node.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.debug.objecttree;

import adams.core.Utils;
import adams.gui.core.BaseTreeNode;

/**
 * Specialized tree node.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3103 $
 */
public class Node
  extends BaseTreeNode {

  /** for serialization. */
  private static final long serialVersionUID = 39921763469189066L;

  /** the name of the property. */
  protected String m_Property;

  /** whether the node is element of an array. */
  protected boolean m_ArrayElement;

  /**
   * Initializes the node.
   *
   * @param property	the name of the property the object belongs to
   * @param obj		the obj to display
   */
  public Node(String property, Object obj) {
    this(property, obj, false);
  }

  /**
   * Initializes the node.
   *
   * @param property	the name of the property the object belongs to
   * @param obj		the obj to display
   * @param element	whether the node is part of an array
   */
  public Node(String property, Object obj, boolean element) {
    super(obj);

    m_Property     = property;
    m_ArrayElement = element;
  }

  /**
   * Returns whether the stored object belongs to an array.
   *
   * @return		true if the stored object belongs to an array
   */
  public boolean isArrayElement() {
    return m_ArrayElement;
  }

  /**
   * Returns whether the stored object is an array.
   *
   * @return		true if the stored object is an array
   */
  public boolean isArray() {
    return getUserObject().getClass().isArray();
  }

  /**
   * Returns a string representation of the stored object.
   *
   * @return		the string representation
   */
  public String toRepresentation() {
    if (isArray())
      return Utils.arrayToString(getUserObject());
    else
      return getUserObject().toString();
  }

  /**
   * Returns the property name of the user object.
   *
   * @return		the property name
   */
  public String toString() {
    StringBuilder	result;
    Class		cls;
    String		levels;

    result = new StringBuilder();
    result.append("<html>");

    if (m_Property == null)
      result.append("this");
    else
      result.append(m_Property);

    result.append(" <font color=\"gray\">[");
    levels = "";
    cls = getUserObject().getClass();
    while (cls.isArray()) {
      levels += "[]";
      cls = cls.getComponentType();
    }
    result.append(cls.getName());
    result.append(levels);
    result.append("]</font>");
    result.append("</html>");

    return result.toString();
  }
}