/*
 * EventsTest.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.standalone;

import adams.env.Environment;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import junit.framework.Test;
import junit.framework.TestSuite;
import adams.flow.core.AbstractActor;
import adams.flow.control.Flow;
import adams.flow.AbstractFlowTest;

/**
 * Test for Events actor.
 *
 * @author fracpete
 * @author adams.core.option.FlowJUnitTestProducer (code generator)
 * @version $Revision: 4255 $
 */
public class EventsTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public EventsTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception 	if an error occurs.
   */
  protected void setUp() throws Exception {
    super.setUp();

    //m_TestHelper.copyResourceToTmp("some.csv");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    //m_TestHelper.deleteFileFromTmp("some.csv");

    super.tearDown();
  }

  /**
   *
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(EventsTest.class);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    AbstractArgumentOption    argOption;

    Flow flow = new Flow();

    try {
      argOption = (AbstractArgumentOption) flow.getOptionManager().findByProperty("actors");
      adams.flow.core.AbstractActor[] tmp1 = new adams.flow.core.AbstractActor[3];
      adams.flow.standalone.Events tmp2 = new adams.flow.standalone.Events();
      argOption = (AbstractArgumentOption) tmp2.getOptionManager().findByProperty("actors");
      adams.flow.core.AbstractActor[] tmp3 = new adams.flow.core.AbstractActor[1];
      adams.flow.control.Flow tmp4 = new adams.flow.control.Flow();
      argOption = (AbstractArgumentOption) tmp4.getOptionManager().findByProperty("name");
      tmp4.setName((java.lang.String) argOption.valueOf("Blah"));

      argOption = (AbstractArgumentOption) tmp4.getOptionManager().findByProperty("actors");
      adams.flow.core.AbstractActor[] tmp6 = new adams.flow.core.AbstractActor[2];
      adams.flow.source.DirectoryLister tmp7 = new adams.flow.source.DirectoryLister();
      argOption = (AbstractArgumentOption) tmp7.getOptionManager().findByProperty("watchDir");
      tmp7.setWatchDir((adams.core.io.PlaceholderDirectory) argOption.valueOf("${TMP}"));

      tmp7.setListFiles(true);

      argOption = (AbstractArgumentOption) tmp7.getOptionManager().findByProperty("sorting");
      tmp7.setSorting((adams.core.io.DirectoryLister.Sorting) argOption.valueOf("SORT_BY_NAME"));

      tmp6[0] = tmp7;
      adams.flow.sink.Display tmp10 = new adams.flow.sink.Display();
      tmp6[1] = tmp10;
      tmp4.setActors(tmp6);

      tmp3[0] = tmp4;
      tmp2.setActors(tmp3);

      tmp1[0] = tmp2;
      adams.flow.source.Start tmp11 = new adams.flow.source.Start();
      tmp1[1] = tmp11;
      adams.flow.control.TriggerEvent tmp12 = new adams.flow.control.TriggerEvent();
      argOption = (AbstractArgumentOption) tmp12.getOptionManager().findByProperty("event");
      tmp12.setEvent((adams.flow.core.TriggerableEventReference) argOption.valueOf("Blah"));

      tmp1[2] = tmp12;
      flow.setActors(tmp1);

    }
    catch (Exception e) {
      fail("Failed to set up actor: " + e);
    }

    return flow;
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(adams.env.Environment.class);
    runTest(suite());
  }
}

