/**
 * TmpDirectory.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.test;

import adams.core.io.PlaceholderDirectory;

/**
 * A simple file handler class that automatically places the directory in the
 * system's tmp directory. But the user still needs to delete the directory
 * manually when it's no longer used.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1484 $
 */
public class TmpDirectory
  extends PlaceholderDirectory {

  /** for serialization. */
  private static final long serialVersionUID = 4323672645601038764L;

  /**
   * Creates a new <code>File</code> instance by converting the given
   * pathname string into an abstract pathname.  If the given string is
   * the empty string, then the result is the empty abstract pathname.
   * Creates a file object pointing to the tmp directory.
   */
  public TmpDirectory() {
    super(System.getProperty("java.io.tmpdir"));
  }

  /**
   * Creates a new <code>File</code> instance by converting the given
   * pathname string into an abstract pathname.  If the given string is
   * the empty string, then the result is the empty abstract pathname.
   *
   * @param   pathname  A pathname string
   */
  public TmpDirectory(String pathname) {
    super(System.getProperty("java.io.tmpdir") + separator + pathname);
  }
}
