/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.IntToString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.ForLoop;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SequenceToArray;
import adams.flow.transformer.StringJoin;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StringJoinTest
extends AbstractFlowTest {
    public StringJoinTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        ForLoop fl = new ForLoop();
        fl.setLoopLower(1);
        fl.setLoopUpper(30);
        fl.setLoopStep(1);
        IntToString i2s = new IntToString();
        Convert con = new Convert();
        con.setConversion((AbstractConversion)i2s);
        SequenceToArray s2a = new SequenceToArray();
        s2a.setArrayLength(10);
        StringJoin sj = new StringJoin();
        sj.setGlue("---");
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{fl, con, s2a, sj, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(StringJoinTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StringJoinTest.runTest(StringJoinTest.suite());
    }
}

