/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.StringRangeCut;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StringRangeCutTest
extends AbstractFlowTest {
    public StringRangeCutTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        StringConstants con = new StringConstants();
        con.setStrings(new BaseString[]{new BaseString("A:BCde"), new BaseString("ab:cde"), new BaseString("ABC:DE"), new BaseString("abcD:E")});
        StringRangeCut actor = new StringRangeCut();
        actor.setType(StringRangeCut.Type.DELIMITED_FIELDS);
        actor.setDelimiter(":");
        actor.setRange("2");
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{con, actor, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    protected void performTest(String[] strIn, String[] strOut, StringRangeCut.Type type, String range, String delim, String glue) {
        StringRangeCut actor = new StringRangeCut();
        actor.setType(type);
        actor.setRange(range);
        actor.setDelimiter(delim);
        actor.setGlue(glue);
        StringRangeCutTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        actor.input(new Token((Object)strIn));
        StringRangeCutTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        Token out = actor.output();
        StringRangeCutTest.assertNotNull((String)"problem with output()", (Object)out);
        String[] strOutActor = (String[])out.getPayload();
        StringRangeCutTest.assertEquals((String)"array length differs", (int)strOut.length, (int)strOutActor.length);
        for (int i = 0; i < strOut.length; ++i) {
            StringRangeCutTest.assertEquals((String)"values differ", (String)strOut[i], (String)strOutActor[i]);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorCharPositions() {
        String[] strIn = new String[]{"abcde", "hello", "world", "bugger"};
        String[] strOut = new String[]{"cde", "llo", "rld", "gge"};
        this.performTest(strIn, strOut, StringRangeCut.Type.CHARACTER_POSITIONS, "3-5", "", "");
    }

    public void testActorCharPositionsWithGlue() {
        String[] strIn = new String[]{"abcdefgh", "the ridiculous", "buggerme"};
        String[] strOut = new String[]{"cde:fgh", "e r:idi", "gge:rme"};
        this.performTest(strIn, strOut, StringRangeCut.Type.CHARACTER_POSITIONS, "3-5,6-8", "", ":");
    }

    public void testActorDelimitedFields() {
        String[] strIn = new String[]{"ab:cde", "hell:o", "w:orld", ":bugger", "blah:"};
        String[] strOut = new String[]{"cde", "o", "orld", "bugger", ""};
        this.performTest(strIn, strOut, StringRangeCut.Type.DELIMITED_FIELDS, "2", ":", "");
    }

    public void testActorDelimitedFieldsWithGlue() {
        String[] strIn = new String[]{"ab:cde:fgh", "hell:o:there", "w:orld:ly", ":bugger:me", "blah:blurb:"};
        String[] strOut = new String[]{"ab\tfgh", "hell\tthere", "w\tly", "\tme", "blah\t"};
        this.performTest(strIn, strOut, StringRangeCut.Type.DELIMITED_FIELDS, "1,3", ":", "\t");
    }

    public static Test suite() {
        return new TestSuite(StringRangeCutTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StringRangeCutTest.runTest(StringRangeCutTest.suite());
    }
}

