/*
 * Decompiled with CFR 0.152.
 */
package adams.test;

import adams.core.annotation.MixedCopyright;
import adams.core.io.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;

@MixedCopyright
public class Regression {
    public static final String REFERENCES = "src/test/resources/regression";
    public static final String EXTENSION = ".ref";
    protected Class m_RegressionClass;
    protected File m_ReferenceFile;

    public Regression(Class cls) {
        this.m_RegressionClass = cls;
        this.m_ReferenceFile = new File("src/test/resources/regression/" + this.m_RegressionClass.getName().replace(".", "/") + EXTENSION);
    }

    public Class getRegressionClass() {
        return this.m_RegressionClass;
    }

    public File getReferenceFile() {
        return this.m_ReferenceFile;
    }

    protected String toString(int start, int end) {
        StringBuffer result = new StringBuffer();
        result.append(end == -1 ? start : 1 + start);
        if (end != -1 && start != end) {
            result.append(",").append(1 + end);
        }
        return result.toString();
    }

    protected String toString(int start, int end, String ind, List<String> lines) {
        StringBuffer result = new StringBuffer();
        for (int i = start; i <= end; ++i) {
            result.append(ind + " " + lines.get(i) + "\n");
        }
        return result.toString();
    }

    protected String compare(List<String> content) {
        if (!this.getReferenceFile().exists()) {
            if (!this.getReferenceFile().getParentFile().exists() && !this.getReferenceFile().getParentFile().mkdirs()) {
                return "Failed to create reference file: " + this.m_ReferenceFile;
            }
            if (FileUtils.saveToFile(content, (File)this.getReferenceFile())) {
                System.err.println("Reference file created: " + this.m_ReferenceFile);
                return null;
            }
            return "Failed to create reference file: " + this.m_ReferenceFile;
        }
        Vector reference = FileUtils.loadFromFile((File)this.getReferenceFile());
        List diffs = new Diff((Collection)reference, content).diff();
        StringBuilder result = new StringBuilder();
        for (Difference diff : diffs) {
            int delStart = diff.getDeletedStart();
            int delEnd = diff.getDeletedEnd();
            int addStart = diff.getAddedStart();
            int addEnd = diff.getAddedEnd();
            String from = this.toString(delStart, delEnd);
            String to = this.toString(addStart, addEnd);
            String type = delEnd != -1 && addEnd != -1 ? "c" : (delEnd == -1 ? "a" : "d");
            result.append(from + type + to + "\n");
            if (delEnd != -1) {
                result.append(this.toString(delStart, delEnd, "<", reference));
                if (addEnd != -1) {
                    result.append("---\n");
                }
            }
            if (addEnd == -1) continue;
            result.append(this.toString(addStart, addEnd, ">", content));
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public static List<String> trim(List<String> list, int[] ignore) {
        if (ignore.length == 0) {
            return list;
        }
        Vector<String> result = new Vector<String>();
        HashSet<Integer> ignored = new HashSet<Integer>();
        for (int ign : ignore) {
            ignored.add(ign);
        }
        for (int i = 0; i < list.size(); ++i) {
            if (ignored.contains(i)) continue;
            result.add(list.get(i));
        }
        return result;
    }

    public String compare(String content) {
        return this.compare(content, "\n");
    }

    public String compare(String content, int[] ignore) {
        return this.compare(content, "\n", ignore);
    }

    public String compare(String content, String nl) {
        return this.compare(content, nl, new int[0]);
    }

    public String compare(String content, String nl, int[] ignore) {
        return this.compare(Regression.trim(Arrays.asList(content.split(nl)), ignore));
    }

    public String compare(File[] files) {
        return this.compare(files, new int[0]);
    }

    public String compare(File[] files, int[] ignore) {
        Vector<String> content = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            content.add("--> " + files[i].getName());
            if (!files[i].exists()) {
                content.add("file is missing");
            } else {
                content.addAll(Regression.trim(FileUtils.loadFromFile((File)files[i]), ignore));
            }
            content.add("");
        }
        return this.compare(content);
    }

    public String compareBinary(File[] files) {
        Vector<String> content = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            content.add("--> " + files[i].getName());
            if (!files[i].exists()) {
                content.add("file is missing");
            } else {
                content.add(new String(FileUtils.loadFromBinaryFile((File)files[i])));
            }
            content.add("");
        }
        return this.compare(content);
    }
}

