/**
 * CronSchedule.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.core.base;

import org.quartz.CronExpression;

/**
 * Encapsulates a cron schedule.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4255 $
 * @see org.quartz.CronExpression
 */
public class CronSchedule
  extends BaseString {

  /** for serialization. */
  private static final long serialVersionUID = -8650732173194720137L;

  /** the default schedule. */
  public final static String DEFAULT = "0 0 1 * * ?";

  /**
   * Initializes with the default schedule.
   *
   * @see	#DEFAULT
   */
  public CronSchedule() {
    this(DEFAULT);
  }

  /**
   * Initializes the object with the specified schedule.
   *
   * @param s		the schedule
   */
  public CronSchedule(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		always true
   */
  public boolean isValid(String value) {
    return CronExpression.isValidExpression(value);
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "An cron schedule.";
  }
}
