/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.flow.core.Compatibility;

public class MultiConversion
extends AbstractConversion {
    private static final long serialVersionUID = -8173803394483284352L;
    protected AbstractConversion[] m_SubConversions;
    protected boolean m_CompatibilityChecked;

    public String globalInfo() {
        return "Meta-conversion that allows the chaining of multiple conversions.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("conversion", "subConversions", new AbstractConversion[0]);
    }

    protected void reset() {
        super.reset();
        this.m_CompatibilityChecked = false;
    }

    public void setSubConversions(AbstractConversion[] value) {
        this.m_SubConversions = value;
        this.reset();
    }

    public AbstractConversion[] getSubConversions() {
        return this.m_SubConversions;
    }

    public String subConversionsTipText() {
        return "The conversions to apply sequentially to the data.";
    }

    public Class accepts() {
        if (this.m_SubConversions.length > 0) {
            return this.m_SubConversions[0].accepts();
        }
        return Object.class;
    }

    public Class generates() {
        if (this.m_SubConversions.length > 0) {
            return this.m_SubConversions[this.m_SubConversions.length - 1].generates();
        }
        return Object.class;
    }

    protected String checkData() {
        String result = super.checkData();
        if (result == null && !this.m_CompatibilityChecked) {
            this.m_CompatibilityChecked = true;
            Compatibility comp = new Compatibility();
            for (int i = 1; i < this.m_SubConversions.length; ++i) {
                if (comp.isCompatible(this.m_SubConversions[i - 1].generates(), this.m_SubConversions[i].accepts())) continue;
                result = "Conversion #" + i + " is not compatible with #" + (i + 1) + ": " + this.m_SubConversions[i - 1].generates().getClass().getName() + " != " + this.m_SubConversions[i].accepts().getClass().getName();
                break;
            }
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        Object result = this.m_Input;
        for (int i = 0; i < this.m_SubConversions.length; ++i) {
            Object input = result;
            this.m_SubConversions[i].setInput(input);
            String msg = this.m_SubConversions[i].convert();
            if (msg != null) {
                throw new IllegalStateException("Conversion #" + (i + 1) + " generated the following error: " + msg);
            }
            result = this.m_SubConversions[i].getOutput();
        }
        return result;
    }
}

