/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractDatabaseConnectionFilter;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.outlier.PassThrough;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlierDetector<T extends DataContainer>
extends AbstractDatabaseConnectionFilter<T> {
    private static final long serialVersionUID = -7381879273745030342L;
    protected AbstractOutlierDetector m_OutlierDetector;
    protected boolean m_OnlyWarning;

    @Override
    public String globalInfo() {
        return "A filter that runs an outlier detector over the data and attaches the generated detections as notes to the chromatogram.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("detector", "detector", new PassThrough());
        this.m_OptionManager.add("only-warning", "onlyWarning", false);
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setDetector(AbstractOutlierDetector value) {
        this.m_OutlierDetector = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractOutlierDetector getDetector() {
        return this.m_OutlierDetector;
    }

    public String detectorTipText() {
        return "The outlier detector to use (the detections generated by the algorithm get attached to the chromatogram).";
    }

    public void setOnlyWarning(boolean value) {
        this.m_OnlyWarning = value;
        this.reset();
    }

    public boolean getOnlyWarning() {
        return this.m_OnlyWarning;
    }

    public String onlyWarningTipText() {
        return "If enabled, the detections get added merely as warnings instead of as errors.";
    }

    @Override
    protected void updateDatabaseConnection() {
        if (this.m_OutlierDetector instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_OutlierDetector)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected T processData(T data) {
        AbstractOutlierDetector detector = this.m_OutlierDetector.shallowCopy(true);
        Vector<String> detection = detector.detect(data);
        detector.destroy();
        this.debug("Data: " + data + ", detection size: " + detection.size());
        DataContainer result = (DataContainer)data.getClone();
        if (result instanceof NotesHandler) {
            NotesHandler handler = (NotesHandler)((Object)result);
            for (int i = 0; i < detection.size(); ++i) {
                if (this.m_OnlyWarning) {
                    handler.getNotes().addWarning(this.m_OutlierDetector.getClass(), detection.get(i));
                } else {
                    handler.getNotes().addError(this.m_OutlierDetector.getClass(), detection.get(i));
                }
                this.debug(i + 1 + ". " + detection.get(i));
            }
        }
        return (T)result;
    }
}

