/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.CsvSpreadSheetReader;
import adams.core.io.SpreadSheet;
import adams.core.option.AbstractOption;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleCSVReportReader<T extends Report>
extends AbstractReportReader<T> {
    private static final long serialVersionUID = 8997935127278404969L;
    public static final String FILE_EXTENSION = "csv";

    @Override
    public String globalInfo() {
        return "Reads a report file in CSV file format.";
    }

    @Override
    public String getFormatDescription() {
        return "Simple report CSV file format";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{FILE_EXTENSION};
    }

    @Override
    protected int determineParentID(Report report) {
        return report.getDatabaseID();
    }

    @Override
    protected Vector<T> readData() {
        Vector result = new Vector();
        result.add(this.newInstance());
        ((Report)result.firstElement()).setDebugLevel(this.getDebugLevel());
        SpreadSheet sheet = new CsvSpreadSheetReader().read(this.getInput().getAbsolutePath());
        String colField = sheet.getHeaderRow().getCellKey(0);
        String colType = sheet.getHeaderRow().getCellKey(1);
        String colValue = sheet.getHeaderRow().getCellKey(2);
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            SpreadSheet.Row row = sheet.getRow(i);
            String fieldStr = row.getCell(colField).getContent();
            DataType type = DataType.valueOf((AbstractOption)null, row.getCell(colType).getContent());
            String value = row.getCell(colValue).getContent();
            if (fieldStr.equals("Parent ID")) {
                ((Report)result.firstElement()).setDatabaseID(Integer.parseInt(value));
                continue;
            }
            Field field = new Field(fieldStr, type);
            ((Report)result.firstElement()).setValue(field, value);
        }
        return result;
    }
}

