/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Utils;
import adams.core.Variables;
import adams.core.VariablesHandler;
import adams.core.io.FlowFile;
import adams.db.LogEntry;
import adams.db.MutableLogEntryHandler;
import adams.flow.control.MutableConnectedControlActor;
import adams.flow.control.Storage;
import adams.flow.control.StorageHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InstantiatableActor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flow
extends MutableConnectedControlActor
implements InstantiatableActor,
MutableLogEntryHandler,
StorageHandler,
VariablesHandler {
    private static final long serialVersionUID = 723059748204261319L;
    protected ErrorHandling m_ErrorHandling;
    protected boolean m_LogErrors;
    protected ArrayList<LogEntry> m_LogEntries;
    protected transient Storage m_Storage;
    protected Variables m_VariablesManager;
    protected FlowFile m_ExecuteOnError;
    protected AbstractActor m_ExecuteOnErrorActor;
    protected FlowFile m_ExecuteOnFinish;
    protected AbstractActor m_ExecuteOnFinishActor;
    protected AbstractActor m_AfterExecuteActor;

    @Override
    public String globalInfo() {
        return "Container object for actors, used for executing a flow.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("error-handling", "errorHandling", (Object)ErrorHandling.ACTORS_ALWAYS_STOP_ON_ERROR);
        this.m_OptionManager.add("log-errors", "logErrors", false);
        this.m_OptionManager.add("execute-on-error", "executeOnError", new FlowFile("."));
        this.m_OptionManager.add("execute-on-finish", "executeOnFinish", new FlowFile("."));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_LogEntries = new ArrayList();
        this.m_VariablesManager = new Variables();
        this.m_ExecuteOnErrorActor = null;
        this.m_ExecuteOnFinishActor = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_AfterExecuteActor = null;
    }

    @Override
    public String getQuickInfo() {
        String result = "";
        String variable = this.getOptionManager().getVariableForProperty("executeOnError");
        String value = "";
        if (variable != null) {
            value = variable;
        } else if (!this.m_ExecuteOnError.isDirectory()) {
            value = this.m_ExecuteOnError.toString();
        }
        if (value.length() > 0) {
            result = result + "on error: " + value;
        }
        variable = this.getOptionManager().getVariableForProperty("executeOnFinish");
        value = "";
        if (variable != null) {
            value = variable;
        } else if (!this.m_ExecuteOnFinish.isDirectory()) {
            value = this.m_ExecuteOnFinish.toString();
        }
        if (value.length() > 0) {
            result = result + "on finish: " + value;
        }
        return result;
    }

    @Override
    public String actorsTipText() {
        return "All the actors that define this flow.";
    }

    public void setErrorHandling(ErrorHandling value) {
        this.m_ErrorHandling = value;
        this.reset();
    }

    public ErrorHandling getErrorHandling() {
        return this.m_ErrorHandling;
    }

    public String errorHandlingTipText() {
        return "Defines how errors are handled that occur during execution of the flow; " + (Object)((Object)ErrorHandling.ACTORS_DECIDE_TO_STOP_ON_ERROR) + " stops the " + "flow only if the actor has the 'stopFlowOnError' flag set.";
    }

    public void setLogErrors(boolean value) {
        this.m_LogErrors = value;
        this.reset();
    }

    public boolean getLogErrors() {
        return this.m_LogErrors;
    }

    public String logErrorsTipText() {
        return "If set to true, errors are logged and can be retrieved after execution.";
    }

    public void setExecuteOnError(FlowFile value) {
        this.m_ExecuteOnError = value;
        this.reset();
    }

    public FlowFile getExecuteOnError() {
        return this.m_ExecuteOnError;
    }

    public String executeOnErrorTipText() {
        return "The external flow to execute in case the flow finishes with an error; allows the user to call a clean-up flow.";
    }

    public void setExecuteOnFinish(FlowFile value) {
        this.m_ExecuteOnFinish = value;
        this.reset();
    }

    public FlowFile getExecuteOnFinish() {
        return this.m_ExecuteOnFinish;
    }

    public String executeOnFinishTipText() {
        return "The external flow to execute in case the flow finishes normal, without any errors.";
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.SEQUENTIAL, false);
    }

    @Override
    public synchronized void setVariables(Variables value) {
    }

    @Override
    public synchronized Variables getVariables() {
        this.m_Variables = this.m_VariablesManager;
        return this.m_VariablesManager;
    }

    @Override
    public String getFullName() {
        this.m_FullName = null;
        return super.getFullName();
    }

    @Override
    public String setUp() {
        Vector<String> errors;
        String result = super.setUp();
        this.getOptionManager().updateVariablesInstance();
        this.m_LogEntries.clear();
        if (result == null && !this.m_ExecuteOnError.isDirectory() && this.m_ExecuteOnError.exists()) {
            errors = new Vector<String>();
            this.m_ExecuteOnErrorActor = ActorUtils.read(this.m_ExecuteOnError.getAbsolutePath(), errors);
            result = !errors.isEmpty() ? "Error loading execute-on-error actor '" + this.m_ExecuteOnError.getAbsolutePath() + "':\n" + Utils.flatten(errors, "\n") : (this.m_ExecuteOnErrorActor == null ? "Error loading execute-on-error actor '" + this.m_ExecuteOnError.getAbsolutePath() + "'!" : this.m_ExecuteOnErrorActor.setUp());
        }
        if (result == null && !this.m_ExecuteOnFinish.isDirectory() && this.m_ExecuteOnFinish.exists()) {
            errors = new Vector();
            this.m_ExecuteOnFinishActor = ActorUtils.read(this.m_ExecuteOnFinish.getAbsolutePath(), errors);
            result = !errors.isEmpty() ? "Finish loading execute-on-finish actor '" + this.m_ExecuteOnFinish.getAbsolutePath() + "':\n" + Utils.flatten(errors, "\n") : (this.m_ExecuteOnFinishActor == null ? "Finish loading execute-on-finish actor '" + this.m_ExecuteOnFinish.getAbsolutePath() + "'!" : this.m_ExecuteOnFinishActor.setUp());
        }
        return result;
    }

    @Override
    public void clearLogEntries() {
        this.m_LogEntries.clear();
    }

    @Override
    public List<LogEntry> getLogEntries() {
        return this.m_LogEntries;
    }

    @Override
    public void addLogEntry(LogEntry entry) {
        if (this.m_LogErrors) {
            this.m_LogEntries.add(entry);
        }
    }

    @Override
    public LogEntry getLogEntry(int index) {
        return this.m_LogEntries.get(index);
    }

    @Override
    public LogEntry removeLogEntry(int index) {
        return this.m_LogEntries.remove(index);
    }

    @Override
    public int countLogEntries() {
        return this.m_LogEntries.size();
    }

    @Override
    public synchronized Storage getStorage() {
        if (this.m_Storage == null) {
            this.m_Storage = new Storage();
        }
        return this.m_Storage;
    }

    @Override
    protected String doExecute() {
        String result = super.doExecute();
        this.m_AfterExecuteActor = null;
        if (this.m_Stopped) {
            if (this.m_ExecuteOnErrorActor != null) {
                this.m_AfterExecuteActor = this.m_ExecuteOnErrorActor;
            }
        } else if (result == null && this.m_ExecuteOnFinishActor != null) {
            this.m_AfterExecuteActor = this.m_ExecuteOnFinishActor;
        }
        if (this.m_AfterExecuteActor != null) {
            this.m_AfterExecuteActor.execute();
            this.m_AfterExecuteActor.wrapUp();
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_LogEntries.clear();
        if (this.m_Storage != null) {
            this.m_Storage.clear();
            this.m_Storage = null;
        }
        if (this.m_AfterExecuteActor != null) {
            this.m_AfterExecuteActor.destroy();
            this.m_AfterExecuteActor = null;
        }
        this.m_VariablesManager.cleanUp();
        super.cleanUp();
    }

    @Override
    public void destroy() {
        this.m_VariablesManager.cleanUp();
        super.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorHandling {
        ACTORS_ALWAYS_STOP_ON_ERROR,
        ACTORS_DECIDE_TO_STOP_ON_ERROR;

    }
}

