/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCombinations
extends AbstractTransformer {
    private static final long serialVersionUID = -1405432778848290110L;
    public static final String BACKUP_ELEMENTS = "elements";
    protected int m_Length;
    protected Vector m_Elements;
    protected SubsetsType m_Subsets;

    @Override
    public String globalInfo() {
        return "Turns an array of any type into a sequence of array combinations of given size.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("length", "length", 1, 1, null);
        this.m_OptionManager.add("subsets", "subsets", (Object)SubsetsType.COMBINATIONS);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("subsets");
        if (variable != null) {
            return variable;
        }
        return this.m_Subsets.toString();
    }

    public void setSubsets(SubsetsType value) {
        this.m_Subsets = value;
        this.reset();
    }

    public SubsetsType getSubsets() {
        return this.m_Subsets;
    }

    public String subsetsTipText() {
        return "combinations or permutations.";
    }

    public void setLength(int len) {
        this.m_Length = len;
        this.reset();
    }

    public int getLength() {
        return this.m_Length;
    }

    public String lengthTipText() {
        return "the r in nCr";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ELEMENTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_ELEMENTS, this.m_Elements);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ELEMENTS)) {
            this.m_Elements = (Vector)state.get(BACKUP_ELEMENTS);
            state.remove(BACKUP_ELEMENTS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Elements = new Vector();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Elements.get(0));
        this.m_Elements.remove(0);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Elements.size() > 0;
    }

    protected Object[] remove(Object[] obj, int pos) {
        Object[] ret = new Object[obj.length - 1];
        int count = 0;
        for (int i = 0; i < obj.length; ++i) {
            if (i == pos) continue;
            ret[count++] = obj[i];
        }
        return ret;
    }

    protected Object[] removeUpToIncluding(Object[] obj, int pos) {
        Object[] ret = new Object[obj.length - (pos + 1)];
        int count = 0;
        for (int i = 0; i < obj.length; ++i) {
            if (i <= pos) continue;
            ret[count++] = obj[i];
        }
        return ret;
    }

    protected Object[] combine(Object o, Object[] arr) {
        Object[] ret = new Object[arr.length + 1];
        ret[0] = o;
        for (int i = 0; i < arr.length; ++i) {
            ret[i + 1] = arr[i];
        }
        return ret;
    }

    protected Vector<Object[]> genCombinations(Object[] in, int num) {
        Vector<Object[]> vobj = new Vector<Object[]>();
        if (num == 0) {
            return vobj;
        }
        for (int i = 0; i < in.length; ++i) {
            if (in.length < num) continue;
            if (num == 1) {
                Object[] o = new Object[]{in[i]};
                vobj.add(o);
                continue;
            }
            Vector<Object[]> combs = this.m_Subsets == SubsetsType.COMBINATIONS ? this.genCombinations(this.removeUpToIncluding(in, i), num - 1) : this.genCombinations(this.remove(in, i), num - 1);
            for (Object[] arr : combs) {
                vobj.add(this.combine(in[i], arr));
            }
        }
        return vobj;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_Elements.clear();
            Object[] array = (Object[])this.m_InputToken.getPayload();
            Vector<Object[]> vobj = this.genCombinations(array, this.m_Length);
            for (Object[] arr : vobj) {
                this.m_Elements.add(arr);
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubsetsType {
        COMBINATIONS,
        PERMUTATIONS;

    }
}

