/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderFile;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.ExtensionFileFilter;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtensionFileFilterFileChooser<F extends ExtensionFileFilter>
extends BaseFileChooser {
    private static final long serialVersionUID = -1607568357690603421L;
    public static final int UNHANDLED_DIALOG = 0;
    public static final int OPEN_DIALOG = 1;
    public static final int SAVE_DIALOG = 2;
    protected AbstractExtensionFileFilterFileChooser m_Self;
    protected int m_DialogType;
    protected Object m_CurrentHandler;
    protected PropertyChangeListener m_Listener;
    protected ExtensionFileFilter m_LastFilter;
    protected boolean m_FileMustExist;

    protected AbstractExtensionFileFilterFileChooser() {
    }

    protected AbstractExtensionFileFilterFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractExtensionFileFilterFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        super.setAcceptAllFileFilterUsed(false);
        this.setFileMustExist(true);
        AbstractExtensionFileFilterFileChooser.initializeFilters(this);
    }

    protected abstract boolean getFiltersInitialized();

    protected abstract void doInitializeFilters();

    protected static synchronized void initializeFilters(AbstractExtensionFileFilterFileChooser chooser) {
        if (!chooser.getFiltersInitialized()) {
            chooser.doInitializeFilters();
        }
    }

    public void setFileMustExist(boolean value) {
        this.m_FileMustExist = value;
    }

    public boolean getFileMustExist() {
        return this.m_FileMustExist;
    }

    protected abstract Vector<F> getOpenFileFilters();

    protected abstract Vector<F> getSaveFileFilters();

    protected void restoreLastFilter(int dialogType) {
        Vector<F> list = dialogType == 1 ? this.getOpenFileFilters() : this.getSaveFileFilters();
        if (list.size() > 0) {
            this.setFileFilter((FileFilter)list.get(0));
            if (this.m_LastFilter != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((ExtensionFileFilter)list.get(i)).compareTo(this.m_LastFilter) != 0) continue;
                    this.setFileFilter(this.m_LastFilter);
                    break;
                }
            }
        }
    }

    protected void initGUI(int dialogType) {
        this.resetChoosableFileFilters();
        Vector<F> list = dialogType == 1 ? this.getOpenFileFilters() : this.getSaveFileFilters();
        for (int i = 0; i < list.size(); ++i) {
            this.addChoosableFileFilter((FileFilter)list.get(i));
        }
        this.restoreLastFilter(dialogType);
        if (this.m_Listener != null) {
            this.removePropertyChangeListener(this.m_Listener);
        }
        this.m_Listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged") && AbstractExtensionFileFilterFileChooser.this.getFileFilter() != null) {
                    AbstractExtensionFileFilterFileChooser.this.updateCurrentHandlerHook();
                }
            }
        };
        this.addPropertyChangeListener(this.m_Listener);
        if (this.getFileFilter() != null) {
            this.updateCurrentHandlerHook();
        }
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        if (this.m_DialogType == 0) {
            throw new IllegalStateException("Either use showOpenDialog or showSaveDialog!");
        }
        return super.showDialog(parent, approveButtonText);
    }

    @Override
    public int showOpenDialog(Component parent) {
        this.m_DialogType = 1;
        this.m_CurrentHandler = null;
        this.initGUI(1);
        int result = super.showOpenDialog(parent);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (result == 0 && this.getFileMustExist() && this.getSelectedPlaceholderFile().isFile() && !this.getSelectedPlaceholderFile().exists()) {
            int retVal = JOptionPane.showConfirmDialog(parent, "The file '" + this.getSelectedPlaceholderFile() + "' does not exist - please select again!");
            result = retVal == 0 ? this.showOpenDialog(parent) : 1;
        }
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter() instanceof ExtensionFileFilter ? (ExtensionFileFilter)this.getFileFilter() : null;
            if (this.getSelectedPlaceholderFile() != null) {
                this.configureCurrentHandlerHook(1);
            }
        }
        return result;
    }

    @Override
    public int showSaveDialog(Component parent) {
        this.m_DialogType = 2;
        this.m_CurrentHandler = null;
        this.initGUI(2);
        FileFilter currentFilter = this.getFileFilter();
        PlaceholderFile currentFile = this.getSelectedPlaceholderFile();
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        int result = super.showSaveDialog(parent);
        currentFilter = this.getFileFilter();
        currentFile = this.getSelectedPlaceholderFile();
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter() instanceof ExtensionFileFilter ? (ExtensionFileFilter)this.getFileFilter() : null;
            if (this.getSelectedPlaceholderFile() != null) {
                this.configureCurrentHandlerHook(2);
            }
        }
        return result;
    }

    protected void updateCurrentHandlerHook() {
    }

    protected void configureCurrentHandlerHook(int dialogType) {
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean b) {
        super.setAcceptAllFileFilterUsed(false);
    }
}

