/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.MouseUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;

public class BaseTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 3893515959380608202L;
    protected boolean m_CloseTabsWithMiddleMouseButton;
    protected MiddleMouseButtonCloseApprover m_MiddleMouseButtonCloseApprover;

    public BaseTabbedPane() {
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    public BaseTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    public BaseTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    protected void initialize() {
        this.m_CloseTabsWithMiddleMouseButton = false;
    }

    protected void initGUI() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                BaseTabbedPane.this.tabClicked(e);
            }
        });
    }

    protected void finishInit() {
    }

    protected void tabClicked(MouseEvent e) {
        int index;
        if (this.m_CloseTabsWithMiddleMouseButton && (index = this.indexAtLocation(e.getX(), e.getY())) >= 0 && MouseUtils.isMiddleClick(e) && this.canCloseTabWithMiddleMouseButton(index)) {
            if (this.m_MiddleMouseButtonCloseApprover != null && !this.m_MiddleMouseButtonCloseApprover.approveClosingWithMiddleMouseButton(this)) {
                return;
            }
            this.removeTabAt(index);
            this.afterTabClosedWithMiddleMouseButton();
        }
    }

    protected boolean canCloseTabWithMiddleMouseButton(int index) {
        return true;
    }

    protected void afterTabClosedWithMiddleMouseButton() {
    }

    public void setCloseTabsWithMiddelMouseButton(boolean value) {
        this.m_CloseTabsWithMiddleMouseButton = value;
    }

    public boolean getCloseTabsWithMiddelMouseButton() {
        return this.m_CloseTabsWithMiddleMouseButton;
    }

    public void setMiddleMouseButtonCloseApprover(MiddleMouseButtonCloseApprover value) {
        this.m_MiddleMouseButtonCloseApprover = value;
    }

    public MiddleMouseButtonCloseApprover getMiddleMouseButtonCloseApprover() {
        return this.m_MiddleMouseButtonCloseApprover;
    }

    public boolean removeSelectedTab() {
        if (this.getSelectedIndex() == -1) {
            return false;
        }
        this.removeTabAt(this.getSelectedIndex());
        return true;
    }

    public static interface MiddleMouseButtonCloseApprover {
        public boolean approveClosingWithMiddleMouseButton(BaseTabbedPane var1);
    }
}

