/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.EnumWithCustomDisplay;
import adams.core.annotation.MixedCopyright;
import adams.gui.core.BaseTree;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.DragAndDropTreeNodeCollection;
import adams.gui.event.NodeDroppedEvent;
import adams.gui.event.NodeDroppedListener;
import adams.gui.flow.tree.Node;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@MixedCopyright
public class DragAndDropTree
extends BaseTree
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private static final long serialVersionUID = 9095408256996103054L;
    protected Point m_Offset;
    protected int m_CueLineExtension;
    protected Color m_ColorCueLine;
    protected Rectangle2D m_RectCueLine;
    protected BaseTreeNode[] m_SourceNode;
    protected DragSource m_DragSource;
    protected DropTarget m_DropTarget;
    protected HashSet<NodeDroppedListener> m_NodeDroppedListeners;
    protected ScheduledExecutorService m_ExpansionExecutor;
    protected int m_ExpansionDelay;

    public DragAndDropTree() {
    }

    public DragAndDropTree(TreeModel model) {
        super(model);
    }

    public DragAndDropTree(TreeNode root) {
        super(root);
    }

    protected void initialize() {
        super.initialize();
        this.m_RectCueLine = new Rectangle2D.Float();
        this.m_DragSource = DragSource.getDefaultDragSource();
        this.m_Offset = new Point();
        this.m_CueLineExtension = 5;
        this.m_ColorCueLine = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
        DragGestureRecognizer dgr = this.m_DragSource.createDefaultDragGestureRecognizer(this, 2, this);
        dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFEFFF);
        this.m_DropTarget = new DropTarget(this, this);
        this.m_DropTarget.setDefaultActions(3);
        this.m_NodeDroppedListeners = new HashSet();
        this.m_ExpansionExecutor = Executors.newScheduledThreadPool(1);
        this.m_ExpansionDelay = 1000;
    }

    public void setExpansionDelay(int value) {
        this.m_ExpansionDelay = value;
    }

    public int getExpansionDelay() {
        return this.m_ExpansionDelay;
    }

    protected BaseTreeNode[] newTreeNodes(Transferable data) {
        String[] parts = data.toString().split("\n");
        BaseTreeNode[] result = new BaseTreeNode[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = new BaseTreeNode(parts[i]);
        }
        return result;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent e) {
        Point p = e.getLocation();
        final TreePath path = this.getClosestPathForLocation(p.x, p.y);
        if (!this.isExpanded(path)) {
            if (this.m_ExpansionDelay > 0) {
                this.m_ExpansionExecutor.schedule(new Runnable(){

                    public void run() {
                        Point newPos = DragAndDropTree.this.getMousePosition();
                        TreePath newPath = DragAndDropTree.this.getClosestPathForLocation(newPos.x, newPos.y);
                        if (newPath.getLastPathComponent() == path.getLastPathComponent()) {
                            DragAndDropTree.this.expandPath(path);
                        }
                    }
                }, (long)this.m_ExpansionDelay, TimeUnit.MILLISECONDS);
            } else {
                this.expandPath(path);
            }
        }
        if (!DragSource.isDragImageSupported() && this.isDropEnabled()) {
            Rectangle rect = this.m_RectCueLine.getBounds();
            this.paintImmediately(rect.x, rect.y, rect.width + 1, rect.height + 1);
            rect = this.getPathBounds(path);
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            g2.setColor(this.m_ColorCueLine);
            this.m_RectCueLine.setRect(rect);
            g2.draw(this.m_RectCueLine);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
        this.repaint();
    }

    public void drop(DropTargetDropEvent e) {
        Point p = e.getLocation();
        TreePath dropPath = this.getClosestPathForLocation(p.x, p.y);
        BaseTreeNode target = dropPath != null ? (BaseTreeNode)dropPath.getLastPathComponent() : null;
        try {
            if (this.isDropEnabled() && target != null) {
                e.acceptDrop(2);
                this.showDropMenu(e, target);
            } else {
                e.getDropTargetContext().dropComplete(false);
                e.rejectDrop();
            }
        }
        catch (Exception ex) {
            e.getDropTargetContext().dropComplete(false);
            ex.printStackTrace();
            e.rejectDrop();
        }
        this.repaint();
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    protected boolean canDrop(Transferable source, TreeNode target, DropPosition position) {
        boolean result = true;
        Node parent = (Node)target.getParent();
        switch (position) {
            case BENEATH: {
                result = true;
                break;
            }
            case HERE: 
            case AFTER: {
                result = parent != null;
                break;
            }
            default: {
                result = false;
                System.err.println("canDrop/Unhandled drop position: " + position);
            }
        }
        return result;
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        this.repaint();
    }

    protected String getDropMenuActionCaption(DropMenu action) {
        if (action == DropMenu.ADD) {
            return "Add";
        }
        if (action == DropMenu.MOVE) {
            return "Move";
        }
        if (action == DropMenu.CANCEL) {
            return "Cancel";
        }
        if (action.getPosition() != null) {
            return action.getPosition().toDisplay();
        }
        return action.toString();
    }

    protected ImageIcon getDropMenuActionIcon(DropMenu action) {
        return null;
    }

    protected void showDropMenu(DropTargetDropEvent e, BaseTreeNode target) {
        DropTargetDropEvent fEvent = e;
        final BaseTreeNode fTarget = target;
        final Transferable fData = e.getTransferable();
        fEvent.getDropTargetContext().dropComplete(true);
        JPopupMenu menu = new JPopupMenu();
        DropMenu action = this.m_SourceNode == null ? DropMenu.ADD : DropMenu.MOVE;
        JMenuItem menuitem = new JMenuItem(this.getDropMenuActionCaption(action), this.getDropMenuActionIcon(action));
        menuitem.setEnabled(false);
        menu.add(menuitem);
        menu.addSeparator();
        DropPosition[] arr$ = DropPosition.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DropPosition pos;
            final DropPosition fPos = pos = arr$[i$];
            menuitem = new JMenuItem(fPos.toDisplay());
            menuitem.setEnabled(this.canDrop(fData, target, fPos));
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DragAndDropTree.this.doDrop(fData, fTarget, fPos);
                    DragAndDropTree.this.m_SourceNode = null;
                }
            });
            menu.add(menuitem);
        }
        menuitem = new JMenuItem("Cancel");
        menuitem.setIcon(this.getDropMenuActionIcon(DropMenu.CANCEL));
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        menu.show(this, e.getLocation().x, e.getLocation().y);
    }

    protected void doDrop(Transferable source, BaseTreeNode target, DropPosition position) {
        BaseTreeNode[] newNodes = null;
        BaseTreeNode parent = null;
        BaseTreeNode top = null;
        newNodes = this.m_SourceNode != null ? this.m_SourceNode : this.newTreeNodes(source);
        this.notifyNodeDroppedListeners(new NodeDroppedEvent((BaseTree)this, newNodes, NodeDroppedEvent.NotificationTime.BEFORE));
        try {
            switch (position) {
                case BENEATH: {
                    parent = target;
                    if (this.m_SourceNode != null) {
                        top = this.getCommonAncestor((BaseTreeNode)this.m_SourceNode[0].getParent(), parent);
                        for (BaseTreeNode node : newNodes) {
                            parent.add(node);
                        }
                    } else {
                        top = parent;
                        for (BaseTreeNode node : newNodes) {
                            parent.add(node);
                        }
                    }
                    break;
                }
                case HERE: 
                case AFTER: {
                    parent = (BaseTreeNode)target.getParent();
                    int targetIndex = parent.getIndex(target);
                    if (position == DropPosition.AFTER) {
                        ++targetIndex;
                    }
                    if (this.m_SourceNode != null) {
                        if (newNodes[0].getParent().equals(parent)) {
                            top = parent;
                            int sourceIndex = parent.getIndex(newNodes[0]);
                            if (sourceIndex < targetIndex) {
                                --targetIndex;
                            }
                            for (BaseTreeNode node : newNodes) {
                                parent.insert(node, targetIndex);
                                ++targetIndex;
                            }
                        } else {
                            top = this.getCommonAncestor(newNodes[0], parent);
                            for (BaseTreeNode node : newNodes) {
                                parent.insert(node, targetIndex);
                                ++targetIndex;
                            }
                        }
                    } else {
                        top = parent;
                        for (BaseTreeNode node : newNodes) {
                            parent.insert(node, targetIndex);
                            ++targetIndex;
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled drop position: " + position);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            parent = null;
            top = null;
            newNodes = null;
            ex.printStackTrace();
        }
        if (parent != null) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(top);
            this.expand(parent);
            if (newNodes != null) {
                this.notifyNodeDroppedListeners(new NodeDroppedEvent((BaseTree)this, newNodes, NodeDroppedEvent.NotificationTime.FINISHED));
            }
        }
    }

    protected Cursor selectCursor(int action) {
        return action == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
    }

    protected boolean isDragEnabled() {
        return false;
    }

    protected boolean isDropEnabled() {
        return false;
    }

    protected boolean canStartDrag(BaseTreeNode[] source) {
        return true;
    }

    protected DragAndDropTreeNodeCollection newNodeCollection(BaseTreeNode[] nodes) {
        return new DragAndDropTreeNodeCollection(nodes);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        this.m_SourceNode = null;
        if (!this.isDragEnabled()) {
            return;
        }
        if (this.getSelectionPath() == null) {
            return;
        }
        if (e.getTriggerEvent().isMetaDown()) {
            return;
        }
        if (this.getSelectionModel().getSelectionMode() == 1) {
            this.m_SourceNode = new BaseTreeNode[1];
            this.m_SourceNode[0] = (BaseTreeNode)this.getSelectionPath().getLastPathComponent();
        } else {
            this.m_SourceNode = new BaseTreeNode[this.getSelectionPaths().length];
            for (int i = 0; i < this.m_SourceNode.length; ++i) {
                this.m_SourceNode[i] = (BaseTreeNode)this.getSelectionPaths()[i].getLastPathComponent();
            }
        }
        if (this.m_SourceNode == null || this.m_SourceNode[0] == null || this.m_SourceNode[0] == this.getModel().getRoot() || !this.canStartDrag(this.m_SourceNode)) {
            return;
        }
        Cursor cursor = this.selectCursor(e.getDragAction());
        this.m_DragSource.startDrag(e, cursor, this.newNodeCollection(this.m_SourceNode), this);
    }

    public void addNodeDroppedListener(NodeDroppedListener l) {
        this.m_NodeDroppedListeners.add(l);
    }

    public void removeNodeDroppedListener(NodeDroppedListener l) {
        this.m_NodeDroppedListeners.remove(l);
    }

    protected void notifyNodeDroppedListeners(NodeDroppedEvent e) {
        for (NodeDroppedListener l : this.m_NodeDroppedListeners) {
            l.nodeDropped(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DropMenu {
        ADD,
        MOVE,
        BENEATH(DropPosition.BENEATH),
        HERE(DropPosition.HERE),
        AFTER(DropPosition.AFTER),
        CANCEL;

        private DropPosition m_Position;

        private DropMenu() {
            this(null);
        }

        private DropMenu(DropPosition position) {
            this.m_Position = position;
        }

        public DropPosition getPosition() {
            return this.m_Position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DropPosition implements EnumWithCustomDisplay<DropPosition>
    {
        BENEATH("Beneath"),
        HERE("Here"),
        AFTER("After");

        private String m_Display;
        private String m_Raw;

        private DropPosition(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        @Override
        public String toDisplay() {
            return this.m_Display;
        }

        @Override
        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        @Override
        public DropPosition parse(String s) {
            DropPosition result = null;
            try {
                result = DropPosition.valueOf(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (DropPosition dt : DropPosition.values()) {
                    if (!dt.toDisplay().equals(s)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

