/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.CleanUpHandler;
import adams.flow.core.AbstractActor;
import adams.gui.core.BaseTabbedPane;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.tree.NodePopupMenuCustomizer;
import adams.gui.flow.tree.Tree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class FlowTabbedPane
extends BaseTabbedPane
implements CleanUpHandler {
    private static final long serialVersionUID = -1675887825433207074L;
    protected FlowEditorPanel m_Owner;
    protected NodePopupMenuCustomizer m_NodePopupMenuCustomizer;

    public FlowTabbedPane(FlowEditorPanel owner) {
        this.m_Owner = owner;
        this.m_NodePopupMenuCustomizer = null;
        this.setCloseTabsWithMiddelMouseButton(true);
        this.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (FlowTabbedPane.this.getPanelCount() == 0) {
                    FlowTabbedPane.this.m_Owner.getTabs().notifyTabs(new TreePath[0], new AbstractActor[0]);
                } else {
                    FlowTabbedPane.this.m_Owner.getTabs().notifyTabs(FlowTabbedPane.this.m_Owner.getCurrentPanel().getTree().getSelectionPaths(), FlowTabbedPane.this.m_Owner.getCurrentPanel().getTree().getSelectedActors());
                }
                FlowTabbedPane.this.updateOwnerTitle();
                FlowTabbedPane.this.m_Owner.update();
            }
        });
    }

    public FlowEditorPanel getOwner() {
        return this.m_Owner;
    }

    public FlowPanel newPanel() {
        FlowPanel result = new FlowPanel(this);
        this.addTab(result.getTitle(), result);
        this.setSelectedComponent(result);
        return result;
    }

    public int getPanelCount() {
        return this.getTabCount();
    }

    public FlowPanel getPanelAt(int index) {
        return (FlowPanel)this.getComponentAt(index);
    }

    public boolean hasCurrentPanel() {
        return this.getCurrentPanel() != null;
    }

    public FlowPanel getCurrentPanel() {
        if (this.getSelectedIndex() != -1) {
            return (FlowPanel)this.getComponentAt(this.getSelectedIndex());
        }
        return null;
    }

    public Tree getTreeAt(int index) {
        return this.getPanelAt(index).getTree();
    }

    public boolean hasCurrentTree() {
        return this.getCurrentTree() != null;
    }

    public Tree getCurrentTree() {
        if (this.getSelectedIndex() != -1) {
            return this.getPanelAt(this.getSelectedIndex()).getTree();
        }
        return null;
    }

    public void cleanUp() {
        for (int i = 0; i < this.getPanelCount(); ++i) {
            this.getPanelAt(i).cleanUp();
        }
    }

    public void setNodePopupMenuCustomizer(NodePopupMenuCustomizer value) {
        this.m_NodePopupMenuCustomizer = value;
        for (int i = 0; i < this.getPanelCount(); ++i) {
            this.getPanelAt(i).getTree().setNodePopupMenuCustomizer(value);
        }
    }

    public NodePopupMenuCustomizer getNodePopupMenuCustomizer() {
        return this.m_NodePopupMenuCustomizer;
    }

    protected boolean checkForModified() {
        if (this.m_Owner == null) {
            return true;
        }
        return this.m_Owner.checkForModified();
    }

    protected boolean canCloseTabWithMiddleMouseButton(int index) {
        return this.checkForModified();
    }

    protected void afterTabClosedWithMiddleMouseButton() {
        this.updateOwnerTitle();
    }

    protected void updateOwnerTitle() {
        if (this.m_Owner == null) {
            return;
        }
        if (this.getPanelCount() == 0) {
            String title = "Flow editor";
            this.m_Owner.setParentTitle(title);
        } else {
            this.getCurrentPanel().updateTitle();
        }
    }

    public void removeTabAt(int index) {
        if (index < 0) {
            return;
        }
        if (!this.checkForModified()) {
            return;
        }
        FlowPanel panel = this.getPanelAt(index);
        panel.cleanUp();
        super.removeTabAt(index);
        this.updateOwnerTitle();
    }
}

