/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.core.option.AbstractOptionProducer;
import adams.core.option.NestedConsumer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.MutableActorHandler;
import java.util.ArrayList;
import java.util.Arrays;

public class ClipboardActorContainer
extends AbstractActor
implements MutableActorHandler {
    private static final long serialVersionUID = 8826708859698352085L;
    protected ArrayList<AbstractActor> m_Actors;

    public String globalInfo() {
        return "Container for copying actors to and pasting from the clipboard";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", new AbstractActor[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new ArrayList();
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.UNDEFINED, false);
    }

    public String check() {
        return null;
    }

    public int size() {
        return this.m_Actors.size();
    }

    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
        this.reset();
    }

    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (!this.m_Actors.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    public AbstractActor firstActive() {
        AbstractActor result = null;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.m_Actors.get(i).getSkip()) continue;
            result = this.m_Actors.get(i);
            break;
        }
        return result;
    }

    public AbstractActor lastActive() {
        AbstractActor result = null;
        for (int i = this.m_Actors.size() - 1; i >= 0; --i) {
            if (this.m_Actors.get(i).getSkip()) continue;
            result = this.m_Actors.get(i);
            break;
        }
        return result;
    }

    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
        this.reset();
    }

    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.clear();
        this.reset();
    }

    public void setActors(AbstractActor[] value) {
        this.m_Actors.clear();
        this.m_Actors.addAll(Arrays.asList(value));
        this.reset();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.toArray(new AbstractActor[this.m_Actors.size()]);
    }

    public String actorsTipText() {
        return "The actors.";
    }

    protected String doExecute() {
        return null;
    }

    public String toNestedString() {
        return AbstractOptionProducer.toString(NestedProducer.class, this);
    }

    public static ClipboardActorContainer fromNestedString(String s) {
        NestedConsumer consumer = new NestedConsumer();
        consumer.setQuiet(true);
        OptionHandler obj = consumer.fromString(s);
        consumer.cleanUp();
        ClipboardActorContainer result = null;
        if (obj != null && obj instanceof ClipboardActorContainer) {
            result = (ClipboardActorContainer)obj;
        } else if (obj instanceof AbstractActor) {
            result = new ClipboardActorContainer();
            result.setActors(new AbstractActor[]{(AbstractActor)obj});
        }
        return result;
    }
}

