/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLister;
import adams.gui.goe.DefaultGenericObjectEditorHandler;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JPanel;

public abstract class AbstractGenericObjectEditorHandler
implements Serializable {
    private static final long serialVersionUID = 5769901293009589319L;
    protected static Hashtable<Class, Class> m_Cache = new Hashtable();
    protected static String[] m_Handlers = null;
    protected static Class[] m_HandlerClasses = null;

    public abstract boolean setClassType(Object var1, Class var2);

    public abstract Class getClassType(Object var1);

    public abstract boolean setCanChangeClassInDialog(Object var1, boolean var2);

    public abstract boolean getCanChangeClassInDialog(Object var1);

    public abstract boolean setValue(Object var1, Object var2);

    public abstract Object getValue(Object var1);

    public boolean handles(Object obj) {
        return this.handles(obj.getClass());
    }

    public abstract boolean handles(Class var1);

    public abstract boolean hasCustomPanel(PropertyEditor var1);

    public abstract JPanel getCustomPanel(PropertyEditor var1);

    protected static synchronized void initHandlers() {
        if (m_Handlers != null) {
            return;
        }
        m_Handlers = ClassLister.getSingleton().getClassnames(AbstractGenericObjectEditorHandler.class);
        m_HandlerClasses = new Class[m_Handlers.length];
        for (int i = 0; i < m_Handlers.length; ++i) {
            try {
                AbstractGenericObjectEditorHandler.m_HandlerClasses[i] = Class.forName(m_Handlers[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate GOE handler '" + m_Handlers[i] + "': ");
                e.printStackTrace();
            }
        }
    }

    public static synchronized AbstractGenericObjectEditorHandler getHandler(Object obj) {
        return AbstractGenericObjectEditorHandler.getHandler(obj.getClass());
    }

    public static synchronized AbstractGenericObjectEditorHandler getHandler(Class cls) {
        AbstractGenericObjectEditorHandler result = null;
        AbstractGenericObjectEditorHandler.initHandlers();
        if (m_Cache.containsKey(cls)) {
            try {
                result = (AbstractGenericObjectEditorHandler)m_Cache.get(cls).newInstance();
                return result;
            }
            catch (Exception e) {
                result = null;
            }
        }
        for (int i = 0; i < m_HandlerClasses.length; ++i) {
            if (m_HandlerClasses[i] == DefaultGenericObjectEditorHandler.class) continue;
            try {
                AbstractGenericObjectEditorHandler handler = (AbstractGenericObjectEditorHandler)m_HandlerClasses[i].newInstance();
                if (!handler.handles(cls)) continue;
                result = handler;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new DefaultGenericObjectEditorHandler();
        }
        m_Cache.put(cls, result.getClass());
        return result;
    }

    public static synchronized String[] getHandlers() {
        AbstractGenericObjectEditorHandler.initHandlers();
        return m_Handlers;
    }
}

