/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.goe.VariableSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public abstract class AbstractPropertyEditorSupport
extends PropertyEditorSupport {
    protected JComponent m_CustomEditor;
    protected WindowAdapter m_WindowAdapter;

    protected AbstractPropertyEditorSupport() {
        this.initialize();
    }

    protected void initialize() {
    }

    public boolean isPaintable() {
        return true;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void setValue(Object value) {
        super.setValue(value);
        if (this.m_CustomEditor != null) {
            this.initForDisplay();
        }
    }

    protected WindowAdapter createWindowAdapter() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AbstractPropertyEditorSupport.this.cleanUp();
                super.windowClosing(e);
            }
        };
    }

    protected void addWindowAdapter() {
        Dialog dlg;
        if (this.m_CustomEditor instanceof Container && (dlg = GUIHelper.getParentDialog(this.m_CustomEditor)) != null) {
            if (this.m_WindowAdapter == null) {
                this.m_WindowAdapter = this.createWindowAdapter();
            }
            dlg.removeWindowListener(this.m_WindowAdapter);
            dlg.addWindowListener(this.m_WindowAdapter);
        }
    }

    protected void cleanUp() {
    }

    protected void closeDialog() {
        Dialog dlg;
        this.cleanUp();
        if (this.m_CustomEditor instanceof Container && (dlg = GUIHelper.getParentDialog(this.m_CustomEditor)) != null) {
            dlg.setVisible(false);
        }
    }

    protected abstract JComponent createCustomEditor();

    protected abstract void initForDisplay();

    public Component getCustomEditor() {
        if (this.m_CustomEditor == null) {
            this.m_CustomEditor = this.createCustomEditor();
            this.m_CustomEditor.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    JPopupMenu popup = AbstractPropertyEditorSupport.this.createPopup();
                    if (MouseUtils.isRightClick(e) && popup != null) {
                        popup.show(AbstractPropertyEditorSupport.this.m_CustomEditor, e.getX(), e.getY());
                    } else {
                        super.mouseClicked(e);
                    }
                }
            });
            this.addWindowAdapter();
        }
        this.initForDisplay();
        return this.m_CustomEditor;
    }

    protected JPopupMenu createPopup() {
        return VariableSupport.createPopup(VariableSupport.findParent(this.m_CustomEditor), this);
    }
}

