/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.classtree;

import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.DragAndDropTreeNodeCollection;
import adams.gui.core.dotnotationtree.DotNotationTree;
import adams.gui.goe.classtree.ClassNode;
import adams.gui.goe.classtree.ClassTreeNodeCollection;
import adams.gui.goe.classtree.ClassTreeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTree
extends DotNotationTree<ClassNode> {
    private static final long serialVersionUID = 1489354474021395304L;

    public ClassTree() {
        this.setSorted(true);
    }

    @Override
    protected TreeCellRenderer getDefaultRenderer() {
        return new ClassTreeRenderer();
    }

    @Override
    protected ClassNode newNode(String label) {
        return new ClassNode(label);
    }

    @Override
    protected DragAndDropTreeNodeCollection newNodeCollection(BaseTreeNode[] nodes) {
        ClassNode[] cnodes = new ClassNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            cnodes[i] = (ClassNode)nodes[i];
        }
        return new ClassTreeNodeCollection(cnodes);
    }

    public static void main(String[] args) {
        Vector<String> classes = new Vector<String>();
        classes.add("weka.classifiers.trees.J48");
        classes.add("weka.classifiers.rules.ZeroR");
        classes.add("dummy.classifiers.trees.MyJ48");
        final ClassTree tree = new ClassTree();
        tree.setItems(classes);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                System.out.println(tree.getSelectedItem());
            }
        });
        final JTextField search = new JTextField();
        search.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }
        });
        JFrame frame = new JFrame("Class tree");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new BaseScrollPane(tree), "Center");
        frame.getContentPane().add((Component)search, "South");
        frame.setSize(640, 480);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        tree.setSelectedItem("weka.classifiers.rules.ZeroR");
    }
}

