/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.gui.print.PostscriptGraphics;
import adams.gui.print.ScalableComponentWriter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;

public class PostscriptWriter
extends ScalableComponentWriter {
    private static final long serialVersionUID = -8501713979661829063L;

    public String globalInfo() {
        return "Outputs EPS files.";
    }

    public String getDescription() {
        return "Postscript-File";
    }

    public String[] getExtensions() {
        return new String[]{".eps"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOutput() throws Exception {
        FilterOutputStream ostrm = null;
        try {
            ostrm = new BufferedOutputStream(new FileOutputStream(this.getFile().getAbsoluteFile()));
            PostscriptGraphics psg = new PostscriptGraphics(this.getComponent().getHeight(), this.getComponent().getWidth(), ostrm);
            psg.setFont(this.getComponent().getFont());
            psg.scale(this.getXScale(), this.getYScale());
            this.getComponent().printAll(psg);
            psg.finished();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (ostrm != null) {
                try {
                    ostrm.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

