/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.scripting.AbstractDataContainerPanelScriptlet;
import adams.gui.visualization.container.ContainerManager;
import java.util.Vector;

public class AddData
extends AbstractDataContainerPanelScriptlet {
    private static final long serialVersionUID = 4553264683463986572L;
    public static final String ACTION = "add-data";

    public String getAction() {
        return ACTION;
    }

    protected String getOptionsDescription() {
        return "<comma-separated list of DB-IDss>";
    }

    public String getDescription() {
        return "Adds the data containers to the currently loaded ones.";
    }

    public String process(String options) throws Exception {
        int i;
        Object manager = this.getDataContainerPanel().getContainerManager();
        String[] list = OptionUtils.splitOptions(options);
        String[] list2 = list[0].split(",");
        int[] ids = new int[list2.length];
        for (i = 0; i < list2.length; ++i) {
            ids[i] = new Integer(list2[i]);
        }
        this.addUndoPoint("Saving undo data...", "Load data: " + Utils.arrayToString(ids));
        Vector data = new Vector();
        for (i = 0; i < ids.length; ++i) {
            if (ids.length > 1) {
                this.showStatus("Loading the data... " + (i + 1) + "/" + ids.length);
            } else {
                this.showStatus("Loading the data...");
            }
            Object c = this.m_DataProvider.load(ids[i]);
            if (c == null) continue;
            data.add(c);
        }
        Vector cont = new Vector();
        for (i = 0; i < data.size(); ++i) {
            cont.add(((ContainerManager)manager).newContainer((Comparable)data.get(i)));
        }
        ((ContainerManager)manager).addAll(cont);
        this.showStatus("");
        return null;
    }
}

