/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.core.io.PlaceholderFile;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileChooser;
import adams.gui.sendto.AbstractSendToAction;
import java.io.File;
import javax.swing.JComponent;

public class ExportAsImage
extends AbstractSendToAction {
    private static final long serialVersionUID = -5286281737195775697L;

    public String getAction() {
        return "Export as image";
    }

    public String getIconName() {
        return "landscape.gif";
    }

    public Class[] accepts() {
        return new Class[]{JComponent.class};
    }

    public String send(Object o) {
        String result = null;
        if (o instanceof JComponent) {
            JComponentWriterFileChooser fileChooser = new JComponentWriterFileChooser();
            JComponent component = (JComponent)o;
            int retVal = fileChooser.showSaveDialog(component);
            if (retVal != 0) {
                result = "Export canceled by user!";
            }
            if (result == null) {
                try {
                    File file = fileChooser.getSelectedFile().getAbsoluteFile();
                    JComponentWriter writer = fileChooser.getWriter();
                    writer.setComponent(component);
                    writer.setFile(new PlaceholderFile(file));
                    writer.toOutput();
                }
                catch (Exception e) {
                    String msg = "Failed to export image: ";
                    result = msg + e;
                    this.getSystemErr().println(msg);
                    this.getSystemErr().printStackTrace(e);
                }
            }
        } else {
            result = "Cannot export object as image: " + o.getClass();
        }
        return result;
    }
}

