/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.core.Variables;
import adams.event.VariableChangeEvent;
import adams.event.VariableChangeListener;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SortableAndSearchableTableWithButtons;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VariableManagementPanel
extends BasePanel
implements CleanUpHandler {
    private static final long serialVersionUID = 8289824326163269560L;
    protected VariableTableModel m_Model;
    protected SortableAndSearchableTableWithButtons m_Table;
    protected BaseFileChooser m_FileChooser;
    protected SearchPanel m_PanelSearch;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.setFileSelectionMode(1);
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Model = new VariableTableModel(new Variables());
        this.m_Table = new SortableAndSearchableTableWithButtons(this.m_Model);
        this.m_Table.getSelectionModel().setSelectionMode(2);
        this.add((Component)this.m_Table, "Center");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                ((SortableAndSearchableTable)VariableManagementPanel.this.m_Table.getComponent()).search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add((Component)panel, "South");
        panel.add(this.m_PanelSearch);
        this.update();
    }

    protected void finishInit() {
        super.finishInit();
        this.m_Model.getVariables().addVariableChangeListener(this.m_Model);
    }

    protected void updateTitle() {
        String title = "Variable management";
        this.setParentTitle(title);
    }

    protected void update() {
        this.updateTitle();
    }

    protected void close() {
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    public void setVariables(Variables value) {
        this.m_Model.getVariables().removeVariableChangeListener(this.m_Model);
        this.m_Model = new VariableTableModel(value);
        this.m_Model.getVariables().addVariableChangeListener(this.m_Model);
        this.m_Table.setModel(this.m_Model);
    }

    public Variables getVariables() {
        return this.m_Model.getVariables();
    }

    public void cleanUp() {
        this.m_Model.getVariables().removeVariableChangeListener(this.m_Model);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VariableTableModel
    extends AbstractBaseTableModel
    implements VariableChangeListener {
        private static final long serialVersionUID = 1842691685087532235L;
        protected Hashtable<String, String> m_Values;
        protected Vector<String> m_Names;
        protected Variables m_Variables;

        public VariableTableModel(Variables variables) {
            this.m_Variables = variables;
            this.initialize();
        }

        protected void initialize() {
            this.m_Names = new Vector();
            this.m_Values = new Hashtable();
            Enumeration<String> enm = this.m_Variables.names();
            while (enm.hasMoreElements()) {
                String name = enm.nextElement();
                this.m_Names.add(name);
                this.m_Values.put(name, this.m_Variables.get(name));
            }
            Collections.sort(this.m_Names);
        }

        public Variables getVariables() {
            return this.m_Variables;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.m_Names.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            throw new IllegalArgumentException("Illegal column: " + columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Name";
            }
            if (column == 1) {
                return "Value";
            }
            throw new IllegalArgumentException("Illegal column: " + column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.m_Names.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.m_Values.get(this.m_Names.get(rowIndex));
            }
            throw new IllegalArgumentException("Illegal column: " + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                String newName = (String)value;
                if (!Variables.isValidName(newName)) {
                    GUIHelper.showErrorMessage(null, "Not a valid variable name: " + newName + "\n" + "Allowed characters:\n" + "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789");
                    return;
                }
                String oldName = this.m_Names.get(rowIndex);
                String oldValue = this.m_Values.get(oldName);
                this.m_Values.remove(oldName);
                this.m_Names.set(rowIndex, newName);
                this.m_Values.put(newName, oldValue);
                this.m_Variables.remove(oldName);
                this.m_Variables.set(newName, oldValue);
            } else if (columnIndex == 1) {
                this.m_Values.put(this.m_Names.get(rowIndex), (String)value);
                this.m_Variables.set(this.m_Names.get(rowIndex), (String)value);
            } else {
                throw new IllegalArgumentException("Illegal column: " + columnIndex);
            }
        }

        public void remove(int rowIndex) {
            this.m_Variables.remove(this.m_Names.get(rowIndex));
        }

        public void add(String name, String value) {
            if (!Variables.isValidName(name)) {
                GUIHelper.showErrorMessage(null, "Not a valid variable name: " + name + "\n" + "Allowed characters:\n" + "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789");
                return;
            }
            if (this.m_Names.contains(name)) {
                return;
            }
            this.m_Variables.set(name, value);
        }

        @Override
        public void variableChanged(VariableChangeEvent e) {
            if (e.getType() == VariableChangeEvent.Type.ADDED) {
                this.m_Names.add(e.getName());
                Collections.sort(this.m_Names);
                this.m_Values.put(e.getName(), this.m_Variables.get(e.getName()));
                int rowIndex = this.m_Names.indexOf(e.getName());
                this.fireTableRowsInserted(rowIndex, rowIndex);
            } else if (e.getType() == VariableChangeEvent.Type.REMOVED) {
                int rowIndex = this.m_Names.indexOf(e.getName());
                this.m_Names.remove(e.getName());
                this.m_Values.remove(e.getName());
                this.fireTableRowsDeleted(rowIndex, rowIndex);
            } else if (e.getType() == VariableChangeEvent.Type.MODIFIED) {
                this.m_Values.put(e.getName(), this.m_Variables.get(e.getName()));
                int rowIndex = this.m_Names.indexOf(e.getName());
                this.fireTableCellUpdated(rowIndex, 1);
            }
        }
    }
}

