/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.visualization.container.Container;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerManager<T extends Container>
implements Serializable {
    private static final long serialVersionUID = -2758522365930747099L;
    protected Vector<T> m_List = new Vector();
    protected HashSet<DataChangeListener> m_DataChangeListeners = new HashSet();
    protected boolean m_Updating = false;

    public void startUpdate() {
        this.m_Updating = true;
    }

    public void finishUpdate() {
        this.finishUpdate(true);
    }

    protected void finishUpdate(boolean notify) {
        this.m_Updating = false;
        if (notify) {
            this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.BULK_UPDATE));
        }
    }

    public boolean isUpdating() {
        return this.m_Updating;
    }

    public void clear() {
        this.m_List.clear();
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.CLEAR));
    }

    public T newContainer(Comparable o) {
        return (T)new Container(this, o);
    }

    public boolean contains(T o) {
        boolean result = false;
        for (int i = 0; i < this.m_List.size(); ++i) {
            if (!((Container)this.m_List.get(i)).equals(o)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected T preAdd(T c) {
        return c;
    }

    public void add(T c) {
        ((Container)c).setManager(this);
        c = this.preAdd(c);
        this.m_List.add(c);
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.ADDITION, this.m_List.size() - 1));
        this.postAdd(c);
    }

    public void postAdd(T c) {
    }

    public void addAll(Collection<T> c) {
        this.startUpdate();
        int[] indices = new int[c.size()];
        Iterator<T> iter = c.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.add((Container)iter.next());
            indices[i] = this.m_List.size() - 1;
            ++i;
        }
        this.finishUpdate(false);
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.ADDITION, indices));
    }

    public T get(int index) {
        return (T)((Container)this.m_List.get(index));
    }

    public Vector<T> getAll() {
        Vector<Container> result = new Vector<Container>();
        for (int i = 0; i < this.count(); ++i) {
            Container cont = ((Container)this.get(i)).copy();
            cont.setManager(null);
            result.add(cont);
        }
        return result;
    }

    protected T preSet(int index, T c) {
        return c;
    }

    public T set(int index, T c) {
        boolean localUpdating;
        boolean bl = localUpdating = !this.m_Updating;
        if (localUpdating) {
            this.m_Updating = true;
        }
        Container result = (Container)this.m_List.set(index, this.preSet(index, c));
        if (localUpdating) {
            this.m_Updating = false;
        }
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.REPLACEMENT, index, result));
        return (T)result;
    }

    public T remove(int index) {
        Container result = (Container)this.m_List.remove(index);
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.REMOVAL, index, result));
        return (T)result;
    }

    public int count() {
        return this.m_List.size();
    }

    public int indexOf(T c) {
        return this.m_List.indexOf(c);
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.m_DataChangeListeners.add(l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.m_DataChangeListeners.remove(l);
    }

    public void notifyDataChangeListeners(DataChangeEvent e) {
        if (this.isUpdating()) {
            return;
        }
        Iterator<DataChangeListener> iter = this.m_DataChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().dataChanged(e);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < this.count(); ++i) {
            result.append(((Container)this.get(i)).toString());
        }
        result.append("]");
        return result.toString();
    }
}

