/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractAxisModel;

public class LogAbsoluteAxisModel
extends AbstractAxisModel {
    private static final long serialVersionUID = -8737139976887145167L;

    public boolean canHandle(double min, double max) {
        return min > 0.0 && max > 0.0;
    }

    public String getDisplayName() {
        return "Log absolute";
    }

    public String valueToDisplay(double value) {
        return this.getActualFormatter().format(value);
    }

    public double displayToValue(String display) {
        return this.getActualFormatter().parse(display);
    }

    public int valueToPos(double value) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        double tmp = Math.log(value) - Math.log(this.m_ActualMinimum);
        tmp /= Math.log(this.m_ActualMaximum) - Math.log(this.m_ActualMinimum);
        int result = (int)Math.round(tmp *= (double)size);
        return result;
    }

    public double posToValue(int pos) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        double tmp = (double)pos / (double)size;
        tmp *= Math.log(this.m_ActualMaximum) - Math.log(this.m_ActualMinimum);
        tmp += Math.log(this.m_ActualMinimum);
        double result = tmp = Math.exp(tmp);
        return result;
    }
}

