/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.AntiAliasingPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequenceLineHitDetector;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;

public class XYSequenceLinePaintlet
extends AbstractXYSequencePaintlet
implements AntiAliasingPaintlet {
    private static final long serialVersionUID = 8242948176244747138L;
    protected int m_MarkerExtent;
    protected boolean m_MarkersEnabled;
    protected boolean m_PaintAll;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for generating a line plot for X-Y sequences.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("markers-extent", "markerExtent", GUIHelper.getInteger(this.getClass(), "markersExtent", 7), 0, null);
        this.m_OptionManager.add("markers-disabled", "markersDisabled", GUIHelper.getBoolean(this.getClass(), "markersEnabled", true) == false);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", GUIHelper.getBoolean(this.getClass(), "antiAliasingEnabled", true));
        this.m_OptionManager.add("paint-all", "paintAll", false);
    }

    public AbstractXYSequencePointHitDetector newHitDetector() {
        return new XYSequenceLineHitDetector(this.getSequencePanel());
    }

    public boolean isMarkersDisabled() {
        return !this.m_MarkersEnabled;
    }

    public void setMarkersDisabled(boolean value) {
        this.m_MarkersEnabled = !value;
        this.memberChanged();
    }

    public String markersDisabledTipText() {
        return "If set to true, the markers are disabled.";
    }

    public void setMarkerExtent(int value) {
        if (value >= 0) {
            this.m_MarkerExtent = value;
            this.memberChanged();
        } else {
            System.err.println("Marker extent must be >= 0 (provided: " + value + ")!");
        }
    }

    public int getMarkerExtent() {
        return this.m_MarkerExtent;
    }

    public String markerExtentTipText() {
        return "The size of the markers in pixels.";
    }

    public boolean getPaintAll() {
        return this.m_PaintAll;
    }

    public void setPaintAll(boolean value) {
        this.m_PaintAll = value;
        this.memberChanged();
    }

    public String paintAllTipText() {
        return "If set to true, all data points will be painted, regardless whether they are visible or not.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    protected void drawData(Graphics g, XYSequence data, Color color, MarkerShape marker) {
        int end;
        int start;
        List<XYSequencePoint> points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        if (this.m_AntiAliasingEnabled) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.m_PaintAll) {
            start = 0;
            end = data.size() - 1;
        } else {
            start = XYSequenceUtils.findClosestX(points, Math.floor(axisX.getMinimum()));
            if (start > 0) {
                --start;
            }
            if ((end = XYSequenceUtils.findClosestX(points, Math.ceil(axisX.getMaximum()))) < data.size() - 1) {
                ++end;
            }
        }
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        int prevX = axisX.valueToPos(((Number)points.get(start).getX()).doubleValue());
        int prevY = axisY.valueToPos(((Number)points.get(start).getY()).doubleValue());
        int prevMarkerX = 0;
        int prevMarkerY = 0;
        for (int i = start; i <= end; ++i) {
            XYSequencePoint curr = points.get(i);
            currX = axisX.valueToPos(XYSequencePoint.toDouble(curr.getX()));
            if (!this.m_PaintAll && i != start && i != end && currX == prevX) continue;
            currY = axisY.valueToPos(XYSequencePoint.toDouble(curr.getY()));
            g.drawLine(prevX, prevY, currX, currY);
            if (marker != MarkerShape.NONE && Math.sqrt(Math.pow(currX - prevMarkerX, 2.0) + Math.pow(currY - prevMarkerY, 2.0)) > (double)(this.m_MarkerExtent * 2)) {
                if (marker == MarkerShape.BOX) {
                    g.drawRect(currX - this.m_MarkerExtent / 2, currY - this.m_MarkerExtent / 2, this.m_MarkerExtent - 1, this.m_MarkerExtent - 1);
                } else if (marker == MarkerShape.CIRCLE) {
                    g.drawArc(currX - this.m_MarkerExtent / 2, currY - this.m_MarkerExtent / 2, this.m_MarkerExtent - 1, this.m_MarkerExtent - 1, 0, 360);
                } else if (marker == MarkerShape.TRIANGLE) {
                    int[] x = new int[3];
                    int[] y = new int[3];
                    x[0] = currX - this.m_MarkerExtent / 2;
                    y[0] = currY + this.m_MarkerExtent / 2;
                    x[1] = x[0] + this.m_MarkerExtent;
                    y[1] = y[0];
                    x[2] = currX;
                    y[2] = y[0] - this.m_MarkerExtent;
                    g.drawPolygon(x, y, 3);
                }
                prevMarkerX = currX;
                prevMarkerY = currY;
            }
            prevX = currX;
            prevY = currY;
        }
    }

    protected MarkerShape getMarkerShape(int index) {
        MarkerShape result = MarkerShape.NONE;
        if (this.m_MarkersEnabled && this.m_MarkerExtent > 0 && this.getPlot().isZoomed()) {
            MarkerShape[] shapes = MarkerShape.values();
            result = shapes[index % (shapes.length - 1) + 1];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPaint(Graphics g) {
        XYSequenceContainerManager xYSequenceContainerManager = (XYSequenceContainerManager)this.getSequencePanel().getContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < ((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).count(); ++i) {
                XYSequence data;
                if (!((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).isVisible(i) || (data = ((XYSequenceContainer)((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawData(g, data, this.getColor(i), this.getMarkerShape(i));
                    continue;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MarkerShape {
        NONE,
        BOX,
        CIRCLE,
        TRIANGLE;

    }
}

