/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;

class RowHeaderRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = -9181159352100487913L;
    private final JTable table;
    private final Border selectedBorder;
    private final Border normalBorder;
    private final Font selectedFont;
    private final Font normalFont;
    final JTableHeader header;

    RowHeaderRenderer(JTable table) {
        this.table = table;
        this.normalBorder = UIManager.getBorder("TableHeader.cellBorder");
        this.selectedBorder = BorderFactory.createRaisedBevelBorder();
        this.header = table.getTableHeader();
        this.selectedFont = this.normalFont = this.header.getFont();
        this.setForeground(this.header.getForeground());
        this.setBackground(this.header.getBackground());
        this.setOpaque(true);
        this.setHorizontalAlignment(4);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.table.getSelectionModel().isSelectedIndex(index)) {
            this.setFont(this.selectedFont);
        } else {
            this.setFont(this.normalFont);
            this.setBackground(this.header.getBackground());
        }
        String label = String.valueOf(value);
        this.setText(String.valueOf(label) + " ");
        return this;
    }
}

