/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgeArrowFunction;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.visualization.ArrowFactory;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.util.GraphicsExecutor;
import org.ujmp.jung.JungGraphPanel;
import org.ujmp.jung.MatrixGraphWrapper;

public class MatrixGraphPanel
extends JungGraphPanel {
    private static final long serialVersionUID = 5267278346111012739L;
    private final MatrixGUIObject matrix = null;

    public MatrixGraphPanel(Matrix matrix) throws MatrixException {
        this((MatrixGUIObject)matrix.getGUIObject());
    }

    public MatrixGraphPanel(MatrixGUIObject matrix) throws MatrixException {
        this();
        this.setMatrix(matrix);
    }

    public MatrixGraphPanel() {
        this.setShowEdgeLabels(false);
        ((PluggableRenderer)this.getRenderer()).setEdgeShapeFunction((EdgeShapeFunction)new EdgeShape.Line());
        ((PluggableRenderer)this.getRenderer()).setEdgePaintFunction(new EdgePaintFunction(){

            public Paint getDrawPaint(Edge e) {
                if (MatrixGraphPanel.this.isShowEdges()) {
                    return new Color(128, 128, 128, 80);
                }
                return null;
            }

            public Paint getFillPaint(Edge e) {
                return null;
            }
        });
        ((PluggableRenderer)this.getRenderer()).setVertexStringer(new VertexStringer(){

            public String getLabel(ArchetypeVertex v) {
                return "" + v.getUserDatum((Object)JungGraphPanel.Data.Label);
            }
        });
        ((PluggableRenderer)this.getRenderer()).setVertexPaintFunction(new VertexPaintFunction(){

            public Paint getFillPaint(Vertex v) {
                if (v.degree() == 0) {
                    return new Color(0, 200, 0, 20);
                }
                if (v.degree() > 29) {
                    return new Color(200, 0, 0, 80);
                }
                return new Color(0, 200, 0, 80);
            }

            public Paint getDrawPaint(Vertex v) {
                return null;
            }
        });
        ((PluggableRenderer)this.getRenderer()).setEdgeStrokeFunction(new EdgeStrokeFunction(){

            public Stroke getStroke(Edge e) {
                return new BasicStroke(0.5f);
            }
        });
        ((PluggableRenderer)this.getRenderer()).setEdgeArrowFunction(new EdgeArrowFunction(){

            public Shape getArrow(Edge e) {
                return ArrowFactory.getNotchedArrow((float)6.0f, (float)6.0f, (float)2.0f);
            }
        });
        ((PluggableRenderer)this.getRenderer()).setVertexShapeFunction(new VertexShapeFunction(){

            public Shape getShape(Vertex v) {
                int size = 2;
                return new Ellipse2D.Float(-size / 2, -size / 2, size, size);
            }
        });
    }

    public void setMatrix(MatrixGUIObject matrix) throws MatrixException {
        this.setGraph((Graph)new MatrixGraphWrapper(matrix));
        GraphicsExecutor.scheduleUpdate(this);
    }

    public MatrixGUIObject getMatrix() {
        return this.matrix;
    }
}

