/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.vecmath;

import javax.vecmath.GMatrix;
import javax.vecmath.GVector;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VecMathDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<GMatrix> {
    private static final long serialVersionUID = 3792684800581150214L;
    private GMatrix matrix = null;

    public VecMathDenseDoubleMatrix2D(GMatrix m) {
        this.matrix = m;
    }

    public VecMathDenseDoubleMatrix2D(long ... size) {
        this.matrix = new GMatrix((int)size[0], (int)size[1]);
        int r = 0;
        while ((long)r < size[0]) {
            int c = 0;
            while ((long)c < size[1]) {
                this.setDouble(0.0, r, c);
                ++c;
            }
            ++r;
        }
    }

    public VecMathDenseDoubleMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setAsDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getElement((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getElement(row, column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.getNumRow(), this.matrix.getNumCol()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setElement((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setElement(row, column, value);
    }

    @Override
    public GMatrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(GMatrix object) {
        this.matrix = object;
    }

    @Override
    public VecMathDenseDoubleMatrix2D transpose() {
        GMatrix m = (GMatrix)this.matrix.clone();
        m.transpose();
        return new VecMathDenseDoubleMatrix2D(m);
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof VecMathDenseDoubleMatrix2D) {
            GMatrix result = (GMatrix)this.matrix.clone();
            result.add(((VecMathDenseDoubleMatrix2D)m).matrix);
            return new VecMathDenseDoubleMatrix2D(result);
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof VecMathDenseDoubleMatrix2D) {
            GMatrix result = (GMatrix)this.matrix.clone();
            result.sub(((VecMathDenseDoubleMatrix2D)m).matrix);
            return new VecMathDenseDoubleMatrix2D(result);
        }
        return super.minus(m);
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof VecMathDenseDoubleMatrix2D) {
            GMatrix result = new GMatrix(this.matrix.getNumRow(), (int)m.getColumnCount());
            result.mul(this.matrix, ((VecMathDenseDoubleMatrix2D)m).matrix);
            return new VecMathDenseDoubleMatrix2D(result);
        }
        return super.mtimes(m);
    }

    @Override
    public DenseDoubleMatrix2D inv() {
        GMatrix m = (GMatrix)this.matrix.clone();
        m.invert();
        return new VecMathDenseDoubleMatrix2D(m);
    }

    @Override
    public Matrix[] svd() {
        GMatrix m = (GMatrix)this.matrix.clone();
        int nrows = (int)this.getRowCount();
        int ncols = (int)this.getColumnCount();
        GMatrix u = new GMatrix(nrows, nrows);
        GMatrix s = new GMatrix(nrows, ncols);
        GMatrix v = new GMatrix(ncols, ncols);
        m.SVD(u, s, v);
        VecMathDenseDoubleMatrix2D U = new VecMathDenseDoubleMatrix2D(u);
        VecMathDenseDoubleMatrix2D S = new VecMathDenseDoubleMatrix2D(s);
        VecMathDenseDoubleMatrix2D V = new VecMathDenseDoubleMatrix2D(v);
        return new Matrix[]{U, S, V};
    }

    @Override
    public Matrix[] lu() {
        if (this.isSquare()) {
            GMatrix m = (GMatrix)this.matrix.clone();
            GMatrix lu = (GMatrix)this.matrix.clone();
            GVector piv = new GVector(this.matrix.getNumCol());
            m.LUD(lu, piv);
            Matrix l = new VecMathDenseDoubleMatrix2D(lu).tril(Calculation.Ret.NEW, 0);
            int i = (int)l.getRowCount() - 1;
            while (i != -1) {
                l.setAsDouble(1.0, i, i);
                --i;
            }
            Matrix u = new VecMathDenseDoubleMatrix2D(lu).triu(Calculation.Ret.NEW, 0);
            VecMathDenseDoubleMatrix2D p = new VecMathDenseDoubleMatrix2D(this.getSize());
            int i2 = piv.getSize() - 1;
            while (i2 != -1) {
                p.setDouble(1.0, i2, (int)piv.getElement(i2));
                --i2;
            }
            return new Matrix[]{l, u, p};
        }
        throw new MatrixException("only allowed for square matrices");
    }
}

