/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.instance.Instance;
import adams.flow.core.Capability;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractWekaInstanceAndWekaInstancesTransformer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import weka.core.Capabilities;
import weka.core.Instances;

public class WekaCapabilities
extends AbstractWekaInstanceAndWekaInstancesTransformer {
    private static final long serialVersionUID = -6171057542176864122L;
    protected Capability[] m_Capabilities;
    protected boolean m_Invert;
    protected Capabilities m_ActualCapabilities;

    public String globalInfo() {
        return "Filters weka.core.Instance and weka.core.Instances based on defined capabilities. Only objects that match the capabilities will be passed on, all others get discarded.\nThe matching sense can be inverted as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("capability", "capabilities", (Object)new Capability[0]);
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_ActualCapabilities = null;
    }

    public void setCapabilities(Capability[] value) {
        this.m_Capabilities = value;
        this.reset();
    }

    public Capability[] getCapabilities() {
        return this.m_Capabilities;
    }

    public String capabilitiesTipText() {
        return "The capabilities that the objects must match.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then objects that failed the capabilities test will pass through and all others get discarded.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActualCapabilities = new Capabilities(null);
            HashSet<Capability> capabilities = new HashSet<Capability>(Arrays.asList(this.m_Capabilities));
            for (Capability c : this.m_Capabilities) {
                this.m_ActualCapabilities.enable(Capability.toWeka(c));
            }
            HashSet<Capabilities.Capability> unwanted = new HashSet<Capabilities.Capability>();
            Iterator iter = this.m_ActualCapabilities.capabilities();
            while (iter.hasNext()) {
                Capabilities.Capability cap = (Capabilities.Capability)iter.next();
                if (capabilities.contains((Object)Capability.toAdams(cap))) continue;
                unwanted.add(cap);
            }
            for (Capabilities.Capability c : unwanted) {
                this.m_ActualCapabilities.disable(c);
            }
            if (this.isDebugOn()) {
                this.debug("Capabilites: " + this.m_ActualCapabilities);
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        boolean forward = false;
        Object o = this.m_InputToken.getPayload();
        Instances inst = null;
        if (o instanceof Instances) {
            inst = (Instances)o;
        } else if (o instanceof Instance) {
            inst = ((Instance)((Object)o)).getDatasetHeader();
        } else if (o instanceof weka.core.Instance) {
            inst = ((weka.core.Instance)o).dataset();
        } else {
            result = "Cannot handle object of type " + o.getClass().getName() + "!";
        }
        if (result == null && (forward = this.m_Invert ? !this.m_ActualCapabilities.test(inst) : this.m_ActualCapabilities.test(inst))) {
            this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        }
        return result;
    }
}

