/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.FileEnvironmentField;
import weka.gui.beans.ImageSaver;

public class ImageSaverCustomizer
extends JPanel
implements BeanCustomizer,
EnvironmentHandler,
CustomizerClosingListener,
CustomizerCloseRequester {
    private static final long serialVersionUID = 5215477777077643368L;
    private ImageSaver m_imageSaver;
    private FileEnvironmentField m_fileEditor;
    private Environment m_env = Environment.getSystemWide();
    private BeanCustomizer.ModifyListener m_modifyListener;
    private Window m_parent;
    private String m_fileBackup;

    public ImageSaverCustomizer() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setObject(Object object) {
        this.m_imageSaver = (ImageSaver)object;
        this.m_fileBackup = this.m_imageSaver.getFilename();
        this.setup();
    }

    private void setup() {
        JPanel holder = new JPanel();
        holder.setLayout(new BorderLayout());
        this.m_fileEditor = new FileEnvironmentField("Filename", this.m_env, 1);
        this.m_fileEditor.resetFileFilters();
        holder.add((Component)this.m_fileEditor, "South");
        String globalInfo = this.m_imageSaver.globalInfo();
        JTextArea jt = new JTextArea();
        jt.setColumns(30);
        jt.setFont(new Font("SansSerif", 0, 12));
        jt.setEditable(false);
        jt.setLineWrap(true);
        jt.setWrapStyleWord(true);
        jt.setText(globalInfo);
        jt.setBackground(this.getBackground());
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("About"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jp.setLayout(new BorderLayout());
        jp.add((Component)jt, "Center");
        holder.add((Component)jp, "North");
        this.add((Component)holder, "Center");
        this.addButtons();
        this.m_fileEditor.setText(this.m_imageSaver.getFilename());
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageSaverCustomizer.this.m_imageSaver.setFilename(ImageSaverCustomizer.this.m_fileEditor.getText());
                if (ImageSaverCustomizer.this.m_modifyListener != null) {
                    ImageSaverCustomizer.this.m_modifyListener.setModifiedStatus(ImageSaverCustomizer.this, true);
                }
                if (ImageSaverCustomizer.this.m_parent != null) {
                    ImageSaverCustomizer.this.m_parent.dispose();
                }
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageSaverCustomizer.this.customizerClosing();
                if (ImageSaverCustomizer.this.m_parent != null) {
                    ImageSaverCustomizer.this.m_parent.dispose();
                }
            }
        });
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }

    @Override
    public void customizerClosing() {
        this.m_imageSaver.setFilename(this.m_fileBackup);
    }
}

